/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.MemberForGroup;
import java.io.IOException;
import java.util.List;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class ListAdministrators
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Group group = DatabaseQuery.getAdminGroup((Database)db);
        List mfgs = DatabaseQuery.getMembersForGroupByGroupIdAlphaCol((Database)db, (int)1, (int)-1, (Long)group.getId());
        UniversalPrinter out = res.getUniversalWriter();
        out.startCollection("administrators");
        for (MemberForGroup mfg : mfgs) {
            out.writeMember(mfg.getMember(), true);
        }
        out.endCollection();
        out.flush();
    }
}

