/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import java.io.IOException;

@Requires(database=true, parameters={"authenticator"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetAuthenticator
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        Member member = req.getAuthenticatedMember();
        assert (member != null);
        String authId = req.getParameter((Parameter)StandardParameters.authenticator);
        assert (authId != null);
        Database db = req.getDatabase();
        Authenticator authenticator = Authenticators.getAuthenticator((Database)db, (long)member.getId(), (String)authId);
        if (authenticator == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Authenticator not found");
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.writeAuthenticator(authenticator);
        out.flush();
    }
}

