/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.security.AccountLockout;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.Moderator;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.db.util.Authenticators;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import com.pageseeder.member.ProfilePictureServlet;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Requires(member=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class DeleteMember
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        String fullname;
        Member mem;
        Database db = req.getDatabase();
        boolean clear = "true".equals(req.getParameter((Parameter)StandardParameters.clear));
        try {
            mem = Members.getMember(req);
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load member from DB");
            return;
        }
        if (mem == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        if (mem.equals((Object)req.getAuthenticatedMember())) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Can't delete yourself");
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("member-delete");
        out.writeMember(mem, true);
        out.endObject();
        HashMap<Long, Group> deletedMemberships = new HashMap<Long, Group>();
        Iterator mfgi = mem.getGroupsForMember();
        while (mfgi.hasNext()) {
            MemberForGroup mfg = (MemberForGroup)mfgi.next();
            Moderator mod = mfg.getModerator();
            if (!mfg.getGroup().getName().startsWith("member-" + mem.getId())) {
                deletedMemberships.put(mfg.getId(), mfg.getGroup());
            }
            mfg.setGroup(null);
            mfg.delete(db);
            if (mod == null) continue;
            mod.delete(db);
        }
        Collection xls = DatabaseQuery.getXLinkMemberDataList((Database)db, (Long)mem.getId());
        for (Object xl : xls) {
            xl.delete(db);
        }
        String string = fullname = clear ? "Name removed" : mem.getFirstName() + " " + mem.getSurname();
        if (fullname.length() > 100) {
            fullname = fullname.substring(0, 100);
        }
        xls = DatabaseQuery.getXLinksByMember((Database)db, (Long)mem.getId());
        for (XLink xl : xls) {
            xl.setAuthorName(fullname);
            xl.setAuthorEmail(clear ? null : mem.getEmail());
            xl.setMember(null);
        }
        xls = DatabaseQuery.getXLinksByModifiedBy((Database)db, (Long)mem.getId());
        for (XLink xl : xls) {
            xl.setModifiedBy(null);
        }
        xls = DatabaseQuery.getXLinksByStatusChangedBy((Database)db, (Long)mem.getId());
        for (XLink xl : xls) {
            xl.setStatusChangedBy(null);
        }
        xls = DatabaseQuery.getXLinksByAssignedTo((Database)db, (Long)mem.getId());
        for (XLink xl : xls) {
            xl.setAssignedTo(null);
        }
        Long pgroupid = null;
        String pgroupname = null;
        try {
            Group pproject;
            Group pgroup = GroupRule.getMemberPersonalGroup((Database)db, (Member)mem);
            if (pgroup != null) {
                pgroupid = pgroup.getId();
                pgroupname = pgroup.getName();
                GroupRule.deleteGroup((Database)db, (Group)pgroup);
                IndexMaster.getInstance().removeIndex(pgroupid.longValue());
            }
            if ((pproject = GroupRule.getMemberPersonalProject((Database)db, (Member)mem)) != null) {
                long pprojectid = pproject.getId();
                GroupRule.deleteGroup((Database)db, (Group)pproject);
                IndexMaster.getInstance().removeIndex(pprojectid);
            }
        }
        catch (FoundationException ex) {
            throw new GeneratorException((Throwable)ex);
        }
        AccountLockout.unlockLogin((String)mem.getUsername());
        AccountLockout.unlockResetPassword((String)mem.getUsername());
        if (!"No Email".equals(mem.getEmail())) {
            AccountLockout.unlockLogin((String)mem.getEmail());
            AccountLockout.unlockResetPassword((String)mem.getEmail());
        }
        AccessTokenManager accessManager = AccessTokenManager.singleton();
        List clients = OAuthQuery.listClientsByMemberID((Database)db, (Long)mem.getId());
        for (Object client : clients) {
            List tokens = OAuthQuery.listPersistentTokensByClientID((Database)db, (Long)client.getId());
            for (PersistentToken token : tokens) {
                token.delete(db);
            }
            accessManager.revokeForClient(client.getIdentifier());
            client.delete(db);
        }
        List tokens = OAuthQuery.listPersistentTokensByMemberID((Database)db, (Long)mem.getId());
        for (Object token : tokens) {
            token.delete(db);
        }
        List authenticators = Authenticators.listAuthenticatorsForMember((Database)db, (long)mem.getId());
        for (Authenticator authenticator : authenticators) {
            authenticator.delete(db);
        }
        accessManager.revokeForMember(mem.getId().longValue());
        new UserDetailsManager().remove(mem.getId());
        ProfilePictureServlet.clearCache(mem.getId());
        Long memid = mem.getId();
        String username = mem.getUsername();
        String email = MemberRule.hasEmail((Member)mem) ? mem.getEmail() : null;
        mem.delete(db);
        req.getTransaction().commit();
        SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.DELETION, (String)"Member {}{} was deleted{}", (Object[])new Object[]{username, username.equals(email) || email == null ? "" : " (" + email + ")", clear ? " and name/email cleared" : ""});
        ChangesManager changes = ChangesManager.getInstance();
        for (Map.Entry m : deletedMemberships.entrySet()) {
            changes.deleteMembership(db, (Long)m.getKey(), (Group)m.getValue());
        }
        changes.deleteMember(db, memid, username, email);
        if (pgroupid != null && pgroupname != null) {
            changes.deleteGroup(db, pgroupid, pgroupname);
        }
        out.flush();
    }
}

