/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mfa.core.AuthenticatorType;
import com.pageseeder.base.mfa.core.ConfidentialData;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import java.io.IOException;
import java.util.List;

@Requires(database=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateAuthenticatorForMember
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        Member member = req.getMember();
        assert (member != null);
        Database db = req.getDatabase();
        Authenticator authenticator = null;
        try {
            AuthenticatorType type = AuthenticatorType.EMAIL_OTP;
            List authenticators = Authenticators.listAuthenticatorsForMemberType((Database)db, (long)member.getId(), (String)type.id());
            for (Authenticator a : authenticators) {
                String email = ConfidentialData.getData((Authenticator)a);
                if (email != null && !email.isEmpty()) continue;
                if (a.isVerified()) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "Unable to create another email-otp verified authenticator");
                    return;
                }
                authenticator = a;
                authenticator.setVerified(true);
            }
            if (authenticator == null) {
                authenticator = new Authenticator();
                authenticator.setType(type.id());
                ConfidentialData.setData((Authenticator)authenticator, (String)"");
                authenticator.setName("Email to your registered email");
                authenticator.setMember(member);
                authenticator.setVerified(true);
                authenticator.insert(db);
                SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Admin created authenticator {}", (Object[])new Object[]{authenticator});
            } else {
                authenticator.setVerified(true);
                SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Admin verified authenticator {}", (Object[])new Object[]{authenticator});
            }
        }
        catch (IllegalArgumentException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("authenticator-creation");
        out.writeAuthenticator(authenticator);
        out.endObject();
        out.flush();
    }
}

