/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.mfa.MFA;
import com.pageseeder.base.mfa.core.AuthenticatorType;
import com.pageseeder.base.mfa.core.ConfidentialData;
import com.pageseeder.base.mfa.recovery.BackupCodes;
import com.pageseeder.base.mfa.sms.InvalidPhoneNumber;
import com.pageseeder.base.mfa.sms.PhoneNumber;
import com.pageseeder.base.mfa.totp.TOTP;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

@Requires(database=true, parameters={"type"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateAuthenticator
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        Authenticator authenticator;
        Member member = req.getAuthenticatedMember();
        assert (member != null);
        String requestedType = req.getParameter((Parameter)StandardParameters.type);
        assert (requestedType != null);
        if (!MFA.isSupportedType((String)requestedType)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Unsupported authenticator type");
            return;
        }
        String name = req.getParameter((Parameter)StandardParameters.name);
        Database db = req.getDatabase();
        try {
            AuthenticatorType type = AuthenticatorType.fromId((String)requestedType);
            List authenticators = Authenticators.listAuthenticatorsForMemberType((Database)db, (long)member.getId(), (String)requestedType);
            if (this.hasReachedMaxAuthenticators(type, authenticators.size())) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Unable to create more authenticators of this type");
                return;
            }
            authenticator = this.createAuthenticator(req, type);
            authenticator.setMember(member);
            if (name != null) {
                authenticator.setName(name);
            }
            authenticator.setVerified(false);
            authenticator.insert(db);
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Created authenticator {}", (Object[])new Object[]{authenticator});
        }
        catch (IllegalArgumentException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, ex.getMessage());
            return;
        }
        catch (InvalidPhoneNumber ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid phone number");
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("authenticator-creation");
        out.writeAuthenticator(authenticator);
        out.endObject();
        out.flush();
    }

    private Authenticator createAuthenticator(GeneratorRequest req, @Nullable AuthenticatorType type) throws IllegalArgumentException, InvalidPhoneNumber {
        if (type == null) {
            throw new IllegalArgumentException("Unsupported authenticator type");
        }
        int digits = (int)req.getParameter("digits", 6L);
        String algorithm = req.getParameter("algorithm", "sha1");
        switch (type) {
            case EMAIL_OTP: {
                return this.createEmailAuthenticator(req.getParameter((Parameter)StandardParameters.email));
            }
            case SMS_OTP: {
                return this.createSMSAuthenticator(req.getParameter("phone"));
            }
            case TOTP: {
                return this.createTOTPAuthenticator(digits, algorithm);
            }
            case WEBAUTHN: {
                return this.createWebAuthnAuthenticator(req.getParameter("attachment"), req.getParameter("hints"));
            }
            case RECOVERY: {
                return this.createRecoveryAuthenticator();
            }
        }
        throw new IllegalArgumentException("Unsupported authenticator type");
    }

    private Authenticator createEmailAuthenticator(@Nullable String email) throws IllegalArgumentException {
        Authenticator authenticator = new Authenticator();
        authenticator.setType(AuthenticatorType.EMAIL_OTP.id());
        if (email != null && !email.isEmpty()) {
            if (!Emails.isAddress((String)email)) {
                throw new IllegalArgumentException("Invalid email address");
            }
            ConfidentialData.setData((Authenticator)authenticator, (String)email);
            authenticator.setName("Email to " + email);
        } else {
            ConfidentialData.setData((Authenticator)authenticator, (String)"");
            authenticator.setName("Email to your registered email");
        }
        return authenticator;
    }

    private Authenticator createSMSAuthenticator(@Nullable String phone) throws IllegalArgumentException, InvalidPhoneNumber {
        if (phone == null) {
            throw new IllegalArgumentException("Missing phone number");
        }
        String phoneE164 = PhoneNumber.of((String)phone).toString();
        Authenticator authenticator = new Authenticator();
        authenticator.setType(AuthenticatorType.SMS_OTP.id());
        ConfidentialData.setData((Authenticator)authenticator, (String)phoneE164);
        authenticator.setName("SMS phone ending in " + phoneE164.substring(phoneE164.length() - 4));
        return authenticator;
    }

    private Authenticator createTOTPAuthenticator(int digits, String algorithm) throws IllegalArgumentException {
        if (!TOTP.isValidCodeLength((int)digits)) {
            throw new IllegalArgumentException("Invalid digits");
        }
        if (!TOTP.isValidAlgorithm((String)algorithm)) {
            throw new IllegalArgumentException("Invalid algorithm");
        }
        Authenticator authenticator = new Authenticator();
        authenticator.setType(AuthenticatorType.TOTP.id());
        ConfidentialData.setData((Authenticator)authenticator, (String)TOTP.newSecret());
        authenticator.setName("Authenticator app");
        TOTP.setParameters((Authenticator)authenticator, (int)digits, (String)algorithm);
        return authenticator;
    }

    private Authenticator createWebAuthnAuthenticator(@Nullable String attachment, @Nullable String hints) {
        String validHints;
        Authenticator authenticator = new Authenticator();
        authenticator.setType(AuthenticatorType.WEBAUTHN.id());
        String validAttachment = CreateAuthenticator.filterAttachment(attachment);
        if (validAttachment != null) {
            authenticator.putParameter("attachment", validAttachment);
        }
        if ((validHints = CreateAuthenticator.filterHints(hints)) != null) {
            authenticator.putParameter("hints", validHints);
        }
        authenticator.setName("Device, passkey or security key");
        return authenticator;
    }

    private Authenticator createRecoveryAuthenticator() {
        Authenticator authenticator = new Authenticator();
        authenticator.setType(AuthenticatorType.RECOVERY.id());
        authenticator.setName("Backup codes (10 left)");
        ConfidentialData.setData((Authenticator)authenticator, (String)BackupCodes.newBackupCodes((int)10).asData());
        return authenticator;
    }

    private boolean hasReachedMaxAuthenticators(AuthenticatorType type, int count) {
        if (type == AuthenticatorType.WEBAUTHN) {
            return count >= 10;
        }
        if (type == AuthenticatorType.TOTP) {
            return count >= 3;
        }
        return count >= 1;
    }

    private static @Nullable String filterHints(@Nullable String hints) {
        if (hints == null) {
            return null;
        }
        StringBuilder filtered = new StringBuilder();
        for (String part : hints.split(",")) {
            if (!part.equals("security-key") && !part.equals("client-device") && !part.equals("hybrid") || filtered.indexOf(part) >= 0) continue;
            if (filtered.length() > 0) {
                filtered.append(",");
            }
            filtered.append(part);
        }
        if (filtered.length() > 0) {
            return filtered.toString();
        }
        return null;
    }

    private static @Nullable String filterAttachment(@Nullable String attachment) {
        if (attachment == null) {
            return null;
        }
        if (attachment.equals("platform") || attachment.equals("cross-platform")) {
            return attachment;
        }
        return null;
    }
}

