/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.security.AccountLockout;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.db.util.Flags;
import com.pageseeder.member.MemberErrorID;
import java.io.IOException;
import java.util.Date;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(database=true, member=true, parameters={"token"})
@PublicAPI
public final class ActivateMemberWithKey
implements Generator,
SingleCheck {
    @ContentPermission(value=NoCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Member member = req.getMember();
        String tokenString = req.getParameter((Parameter)StandardParameters.token);
        assert (member != null && tokenString != null);
        PersistentToken token = OAuthQuery.getPersistentToken((Database)db, (String)tokenString, (Member)member);
        if (token == null || !token.hasPurpose(PersistentToken.Purpose.activate_member) || token.hasExpired()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_INVALID);
            return;
        }
        boolean alreadyActive = true;
        if (!MemberRule.isMemberActivated((Member)member)) {
            alreadyActive = false;
            member.setSubmitPref(Flags.remove((String)member.getSubmitPref(), (char)'u'));
            member.setActivated(new Date());
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Member {} ({}) activated their account", (Object[])new Object[]{member.getUsername(), member.getId()});
            if (token != null) {
                token.delete(db);
            }
        }
        AccountLockout.unlockLogin((String)member.getUsername());
        AccountLockout.unlockLogin((String)member.getEmail());
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("member-activation");
        if (alreadyActive) {
            out.field("already-activated", true);
        }
        out.writeMember(member);
        out.endObject();
        out.flush();
        new MembershipCache().remove(member.getId());
    }
}

