/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.mail;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.net.URLs;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Requires(parameters={"name"})
public class SampleXML
implements Generator,
SingleCheck {
    private final Map<String, String> samples = new HashMap<String, String>();

    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        XMLWriter xml;
        String name = req.getParameter((Parameter)StandardParameters.name);
        assert (name != null);
        String sample = this.samples.get(name);
        if (sample == null) {
            xml = new XMLStringWriter(XML.NamespaceAware.No, false);
            InputStream in = this.getClass().getResourceAsStream("/com/pageseeder/mail/sample/" + name + ".xml");
            if (in != null) {
                SampleHandler handler = new SampleHandler(xml, req.getHttpServletRequest());
                try {
                    XMLHelpers.parse((InputStream)in, (ContentHandler)handler);
                }
                catch (FoundationException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to parse sample XML: " + ex.getMessage());
                    return;
                }
                finally {
                    in.close();
                }
            }
            if ((sample = xml.toString()).isEmpty()) {
                sample = null;
            }
            this.samples.put(name, sample);
        }
        if (sample == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Invalid notification sample name " + name);
        } else {
            xml = res.getXMLWriter();
            xml.writeXML(sample);
        }
    }

    private static final class SampleHandler
    extends DefaultHandler {
        private final XMLWriter output;
        private final String host;
        private final String emailDomain;

        public SampleHandler(XMLWriter out, HttpServletRequest r) {
            this.output = out;
            this.host = r.getServerName();
            String domain = GlobalSettings.getString((String)"emailSenderDomain", (String)GlobalSettings.get((String)"emailDomain"));
            if (domain == null || domain.isEmpty() || "pshosts".equals(domain)) {
                domain = GlobalSettings.get((String)"webSiteAddress");
            }
            this.emailDomain = domain;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                boolean notification = "notification".equals(localName);
                this.output.openElement(localName, true);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getLocalName(i);
                    if (notification && ("emaildomain".equals(name) || "hosturl".equals(name))) continue;
                    this.output.attribute(name, attributes.getValue(i));
                }
                if (notification) {
                    this.output.attribute("emaildomain", this.emailDomain);
                    String siteprefix = GlobalSettings.getSitePrefix();
                    this.output.attribute("hosturl", URLs.asString((String)Settings.getServerScheme(), (String)this.host, (int)Settings.getServerPort(), (String)siteprefix));
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + localName, ex);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                this.output.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close element " + localName, ex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.output.writeText(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write text", ex);
            }
        }
    }
}

