/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.servlets;

import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewMembersCheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.FileAttributes;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.MD5;
import com.pageseeder.common.util.Strings;
import com.pageseeder.common.util.ZipChecker;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingThreadFactory;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.load.servlets.UploadException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI(value=PublicAPI.Support.SUPPORTED)
public final class LoadingZoneUpload
extends HttpServlet {
    private static final long serialVersionUID = -5105806261737039910L;
    private static final String FILENAME_HEADER = "X-File-Name";
    private static final String GROUP_PARAMETER = "group";
    private static final String FOLDER_PARAMETER = "folder";
    private static final String URL_PARAMETER = "url";
    private static final String MEMBER_PARAMETER = StandardParameters.member.name();
    private static final String OVERWRITE_PARAMETER = "overwrite";
    private static final String OVERWRITE_PROPERTIES_PARAMETER = "overwrite-properties";
    private static final String UPLOADID_PARAMETER = "uploadid";
    private static final String XLINKID_PARAMETER = "xlinkid";
    private static final String TITLE_PARAMETER = "title";
    private static final String DOCID_PARAMETER = "docid";
    private static final String LABELS_PARAMETER = "labels";
    private static final String DESCRIPTION_PARAMETER = "description";
    private static final String AUTOLOAD_PARAMETER = "autoload";
    private static final String FILENAME_PARAMETER = "filename";
    private static final String ROOT_FOLDER = "/";
    private static final String TRUE = "true";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadingZoneUpload.class);
    public static final long DEFAULT_MAX_UPLOAD_SIZE = 100000000L;

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        IncomingFile file;
        String uploadid;
        Long authorid;
        long start = System.currentTimeMillis();
        Long groupId = null;
        String groupName = null;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        boolean autoload = TRUE.equals(req.getParameter(AUTOLOAD_PARAMETER));
        String xlinkid = req.getParameter(XLINKID_PARAMETER);
        String uploadidParam = req.getParameter(UPLOADID_PARAMETER);
        String groupname = req.getParameter(GROUP_PARAMETER);
        String folder = req.getParameter(FOLDER_PARAMETER);
        String url = req.getParameter(URL_PARAMETER);
        String member = req.getParameter(MEMBER_PARAMETER);
        RequestDetails details = null;
        Database db = WebRequest.getDatabase((HttpServletResponse)res);
        if (db == null) {
            return;
        }
        boolean ok = LoadingZoneUpload.checkPutPreconditions(req, res);
        if (!ok) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            LoadingZone zone;
            String extension;
            ViewMembersCheck check;
            tr.begin();
            Permissions perm = new Permissions();
            Group gp = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
            if (gp == null) {
                res.sendError(400, "Invalid group");
                tr.abort();
                return;
            }
            groupId = gp.getId();
            groupName = gp.getName();
            URL u = null;
            if (autoload && (u = LoadingZoneUpload.computeDestination(gp, url, folder, db, res)) == null) {
                tr.abort();
                return;
            }
            Member author = null;
            if (member != null && (author = MemberRule.getMember((Database)db, (String)member)) == null) {
                res.sendError(400, "Invalid member");
                tr.abort();
                return;
            }
            ViewMembersCheck viewMembersCheck = uploadidParam == null && xlinkid != null ? new ViewMembersCheck(gp) : (check = u == null ? new EditURICheck(gp) : new EditURICheck(gp, u.toString()));
            if (author != null) {
                check = new ViewMemberCheck(author, (PermissionCheck)check);
            }
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)check)) {
                tr.abort();
                return;
            }
            assert (perm.getUserDetails() != null);
            boolean admin = MemberRule.isAdministrator((Map)perm.getUserDetails().flags());
            if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
                res.sendError(419, "Missing correct CSRF token");
                tr.abort();
                HttpRequests.consumeInputStream((HttpServletRequest)req);
                return;
            }
            String filename = req.getHeader(FILENAME_HEADER);
            if (filename == null) {
                filename = req.getParameter(FILENAME_PARAMETER);
            }
            String string = extension = filename == null ? null : URIRule.getExtension((String)filename).toLowerCase();
            if (extension != null) {
                if (xlinkid != null && extension.equals("psml")) {
                    res.sendError(400, "PSML files can't be attached");
                    tr.abort();
                    return;
                }
                if (xlinkid != null && RuleUtils.forbiddenAttachmentExtensions().contains(extension)) {
                    res.sendError(400, "Files with this extension can't be attached as they may be harmful");
                    tr.abort();
                    return;
                }
                if (!admin && RuleUtils.forbiddenUploadExtensions().contains(extension)) {
                    res.sendError(400, "Files with this extension can only be uploaded by administrators as they may be harmful");
                    tr.abort();
                    return;
                }
            }
            if (author == null) {
                author = DatabaseQuery.getMemberById((Database)db, (Long)perm.getMemberId());
            }
            authorid = author.getId();
            uploadid = LoadingZone.getUploadID(uploadidParam, xlinkid, db, author);
            if (uploadid == null && (uploadidParam != null || xlinkid != null)) {
                res.sendError(404, "Invalid uploadid or xlinkid");
                tr.abort();
                return;
            }
            if (autoload && uploadid == null) {
                uploadid = LoadingZoneUpload.generateUploadID();
            }
            if ((file = (zone = new LoadingZone(groupname, gp.getOwnerDirectory(), authorid, uploadid)).newFile(filename)).exists() && !TRUE.equals(req.getParameter(OVERWRITE_PARAMETER))) {
                res.sendError(409, "Destination file already exist and overwrite is set to false");
                tr.abort();
                return;
            }
            if (xlinkid != null) {
                zone.loadExistingFiles();
                if (LoadingZoneUpload.tooManyFiles(zone)) {
                    res.sendError(400, "Maximum number of files has been reached");
                    tr.abort();
                    return;
                }
            }
            LOGGER.debug("destination: {}", (Object)file);
            try (ServletInputStream in = req.getInputStream();){
                file.save((InputStream)in);
            }
            catch (IOException ex) {
                res.sendError(500, "Failed to write new file: " + ex.getMessage());
                tr.abort();
                db.close();
                return;
            }
            if ("zip".equalsIgnoreCase(extension) && LoadingZoneUpload.isInvalidZip(file.getFile())) {
                file.getFile().delete();
                res.sendError(400, "Ignoring malicious/invalid ZIP file");
                tr.abort();
                return;
            }
            if (autoload) {
                file.inspect(zone);
                LoadingZoneUpload.updateZoneForAutoload(zone, LoadingZoneUpload.getParameters(req));
                details = new RequestDetails(author.getUsername(), authorid, perm.getAddEditXLinks(), u, gp.getId(), gp.getName(), gp.getOwnerDirectory(), TRUE.equals(req.getParameter(OVERWRITE_PARAMETER)), TRUE.equals(req.getParameter(OVERWRITE_PROPERTIES_PARAMETER)), zone);
            } else if (file.isMetadataPSML()) {
                File original = Files.descendantFile((File)zone.baseDirectory(), (String)file.getPath().replaceAll("(^meta-inf/)|(^META-INF/)|(\\.psml$)|(\\.PSML$)", ""));
                if (original.exists() && original.isFile()) {
                    FileAttributes.clear((File)original);
                }
            } else {
                file.checkMetadataFile(zone);
                file.inspect(zone);
            }
            tr.commit();
        }
        catch (StartTransactionException ex) {
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (Exception)((Object)ex));
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"upload", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER, groupId, groupName);
            return;
        }
        catch (Exception ex) {
            tr.abort();
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"upload", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER, groupId, groupName);
            throw new ServletException((Throwable)ex);
        }
        finally {
            db.close();
        }
        res.setContentType("application/xml");
        res.setCharacterEncoding("utf-8");
        UniversalPrinter xml = UniversalPrinter.newWriter((OutputType)OutputType.XML);
        xml.startObject("upload");
        xml.field("member", String.valueOf(authorid));
        xml.optionalField(UPLOADID_PARAMETER, uploadid);
        xml.field("max-workflow-notifications", (long)GlobalSettings.getInt((String)"maxWorkflowNotifications", (int)20));
        LoadingThread thread = null;
        if (autoload && xlinkid == null) {
            thread = LoadingZoneUpload.autoload(details, xml);
        } else {
            file.print((OutputPrinter)xml);
        }
        xml.endObject();
        xml.flush();
        res.getWriter().write(xml.toString());
        int statusId = 200;
        if (thread != null) {
            ProcessStage.Status status = thread.getCurrentStatus().getStatus();
            if (status == ProcessStage.Status.FAILED) {
                statusId = thread.hadConflicts() ? 409 : 400;
            } else if (!thread.isFinished()) {
                statusId = 202;
            }
            res.setStatus(statusId);
        }
        WebUtilities.logAccess((HttpServletRequest)req, (int)statusId, (String)"upload", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER, (Long)groupId, (String)groupName);
    }

    public static boolean tooManyFiles(LoadingZone zone) {
        int max = GlobalSettings.getInt((String)"maxAttachmentNumber", (int)20);
        return zone.getIncomingFiles().size() >= max;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        List<IncomingFile> files;
        String uploadID;
        long start = System.currentTimeMillis();
        Long groupId = null;
        String groupName = null;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        boolean autoload = TRUE.equals(req.getParameter(AUTOLOAD_PARAMETER));
        String xlinkid = req.getParameter(XLINKID_PARAMETER);
        String uploadidParam = req.getParameter(UPLOADID_PARAMETER);
        String folder = req.getParameter(FOLDER_PARAMETER);
        String url = req.getParameter(URL_PARAMETER);
        String member = req.getParameter(MEMBER_PARAMETER);
        Long authorid = null;
        RequestDetails details = null;
        Database db = WebRequest.getDatabase((HttpServletResponse)res);
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            ViewMembersCheck check;
            List<FileItem> items;
            tr.begin();
            Permissions perm = new Permissions();
            Map<String, String> params = LoadingZoneUpload.getParameters(req);
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                res.sendError(400, "The request must be Multipart");
                return;
            }
            DiskFileItemFactory factory = new DiskFileItemFactory();
            try {
                items = LoadingZoneUpload.parseRequest((FileItemFactory)factory, req);
            }
            catch (FileUploadBase.SizeLimitExceededException ex) {
                tr.abort();
                res.sendError(413, LoadingZoneUpload.lengthExceededMessage());
                HttpRequests.consumeInputStream((HttpServletRequest)req);
                db.close();
                return;
            }
            String groupParam = req.getParameter(GROUP_PARAMETER);
            for (FileItem item : items) {
                if (GROUP_PARAMETER.equals(item.getFieldName())) {
                    groupParam = item.getString();
                    continue;
                }
                if (AUTOLOAD_PARAMETER.equals(item.getFieldName())) {
                    autoload = TRUE.equals(item.getString());
                    continue;
                }
                if (XLINKID_PARAMETER.equals(item.getFieldName())) {
                    xlinkid = item.getString();
                    continue;
                }
                if (UPLOADID_PARAMETER.equals(item.getFieldName())) {
                    uploadidParam = item.getString();
                    continue;
                }
                if (FOLDER_PARAMETER.equals(item.getFieldName())) {
                    folder = item.getString();
                    continue;
                }
                if (URL_PARAMETER.equals(item.getFieldName())) {
                    url = item.getString();
                    continue;
                }
                if (MEMBER_PARAMETER.equals(item.getFieldName())) {
                    member = item.getString();
                    continue;
                }
                if (!item.isFormField()) continue;
                params.put(item.getFieldName(), item.getString());
            }
            String groupname = LoadingZoneUpload.validateGroup(groupParam, db, res);
            if (groupname == null) {
                tr.abort();
                return;
            }
            Group group = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
            groupId = group.getId();
            groupName = group.getName();
            URL destination = null;
            if (autoload && (destination = LoadingZoneUpload.computeDestination(group, url, folder, db, res)) == null) {
                tr.abort();
                return;
            }
            Member author = null;
            if (member != null && (author = MemberRule.getMember((Database)db, (String)member)) == null) {
                res.sendError(400, "Invalid member");
                tr.abort();
                return;
            }
            ViewMembersCheck viewMembersCheck = uploadidParam == null && xlinkid != null ? new ViewMembersCheck(group) : (check = destination == null ? new EditURICheck(group) : new EditURICheck(group, destination.toString()));
            if (author != null) {
                check = new ViewMemberCheck(author, (PermissionCheck)check);
            }
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)check)) {
                tr.abort();
                return;
            }
            if (author == null) {
                author = DatabaseQuery.getMemberById((Database)db, (Long)perm.getMemberId());
            }
            authorid = author.getId();
            uploadID = LoadingZone.getUploadID(uploadidParam, xlinkid, db, author);
            if (uploadID == null && (uploadidParam != null || xlinkid != null)) {
                res.sendError(400, "Invalid uploadid or xlinkid");
                return;
            }
            if (autoload && uploadID == null) {
                uploadID = LoadingZoneUpload.generateUploadID();
            }
            LoadingZone zone = new LoadingZone(groupname, group.getOwnerDirectory(), author.getId(), uploadID);
            if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
                res.sendError(419, "Missing correct CSRF token");
                tr.abort();
                HttpRequests.consumeInputStream((HttpServletRequest)req);
                return;
            }
            try {
                files = LoadingZoneUpload.createFromMultipart(zone, items, params, TRUE.equals(params.get(OVERWRITE_PARAMETER)), xlinkid != null, MemberRule.isAdministrator((Map)perm.getUserDetails().flags()));
            }
            catch (UploadException ex) {
                tr.abort();
                res.sendError(ex.httpCode(), ex.getMessage());
                db.close();
                return;
            }
            if (autoload) {
                details = new RequestDetails(author.getUsername(), author.getId(), perm.getAddEditXLinks(), destination, group.getId(), group.getName(), group.getOwnerDirectory(), TRUE.equals(params.get(OVERWRITE_PARAMETER)), TRUE.equals(params.get(OVERWRITE_PROPERTIES_PARAMETER)), zone);
            }
            tr.commit();
        }
        catch (StartTransactionException ex) {
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (Exception)((Object)ex));
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"upload", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER, groupId, groupName);
            return;
        }
        catch (Exception ex) {
            tr.abort();
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"upload", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER, groupId, groupName);
            throw new ServletException((Throwable)ex);
        }
        finally {
            db.close();
        }
        res.setContentType("application/xml");
        res.setCharacterEncoding("utf-8");
        try (UniversalPrinter printer = UniversalPrinter.newWriter((OutputType)OutputType.XML);){
            printer.startObject("upload");
            printer.field("member", String.valueOf(authorid));
            printer.optionalField(UPLOADID_PARAMETER, uploadID);
            printer.field("max-workflow-notifications", (long)GlobalSettings.getInt((String)"maxWorkflowNotifications", (int)20));
            LoadingThread thread = null;
            if (autoload && xlinkid == null) {
                thread = LoadingZoneUpload.autoload(details, printer);
            } else {
                for (IncomingFile file : files) {
                    file.print((OutputPrinter)printer);
                }
            }
            printer.endObject();
            printer.flush();
            res.getWriter().write(printer.toString());
            int statusId = 200;
            if (thread != null) {
                ProcessStage.Status status = thread.getCurrentStatus().getStatus();
                if (status == ProcessStage.Status.FAILED) {
                    statusId = thread.hadConflicts() ? 409 : 400;
                } else if (!thread.isFinished()) {
                    statusId = 202;
                }
                res.setStatus(statusId);
            }
            WebUtilities.logAccess((HttpServletRequest)req, (int)statusId, (String)"upload", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER, (Long)groupId, (String)groupName);
        }
    }

    private static URL computeDestination(Group group, @Nullable String url, @Nullable String folder, Database db, HttpServletResponse res) throws IOException, DatabaseException {
        if (url != null) {
            int pathStart;
            int schemeEnd = ((String)(url = URLDecoder.decode((String)url, StandardCharsets.UTF_8))).indexOf("://");
            if (schemeEnd > 0 && (pathStart = ((String)url).indexOf(47, schemeEnd + 3)) > 0) {
                url = ((String)url).substring(0, pathStart) + RuleUtils.replaceNonFolderCharsKeepSlashes((String)((String)url).substring(pathStart));
            }
        } else {
            GroupURI guri = GroupURIRule.getDefaultGroupURI((Group)group);
            if (guri == null) {
                res.sendError(500, "There is no default Group URI in the group.");
                return null;
            }
            Object folderpath = folder != null ? ROOT_FOLDER + folder : "";
            url = GroupURIs.truncatePath((String)GroupURIRule.getURIString((GroupURI)guri)) + RuleUtils.replaceNonFolderCharsKeepSlashes((String)URLDecoder.decode((String)folderpath, StandardCharsets.UTF_8));
        }
        if (((String)url).endsWith(ROOT_FOLDER)) {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        try {
            return URIRule.computeURL((String)url, (Database)db);
        }
        catch (MalformedURLException ex) {
            res.sendError(400, "Invalid destination");
            return null;
        }
    }

    public String getServletInfo() {
        return "Uploads one or more files.";
    }

    public static void updateZoneForAutoload(LoadingZone zone, Map<String, String> parameters) {
        String filedescription;
        String filelabels;
        String filetitle;
        if (zone.isEmpty()) {
            return;
        }
        IncomingFile file = zone.getIncomingFiles().iterator().next();
        String filedocid = parameters.get(DOCID_PARAMETER);
        if (filedocid != null && !filedocid.isEmpty()) {
            file.setDocumentid(filedocid);
        }
        if ((filetitle = parameters.get(TITLE_PARAMETER)) != null && !filetitle.isEmpty()) {
            file.setUsertitle(filetitle);
        }
        if ((filelabels = parameters.get(LABELS_PARAMETER)) != null && !filelabels.isEmpty()) {
            file.setLabels(Strings.split((String)filelabels, (char)','));
        }
        if ((filedescription = parameters.get(DESCRIPTION_PARAMETER)) != null && !filedescription.isEmpty()) {
            file.setDescription(filedescription);
        }
    }

    private static LoadingThread autoload(RequestDetails details, UniversalPrinter out) {
        LoadingThread thread = LoadingThreadFactory.createDefault(details.username(), details.contributor(), details.groupid(), details.groupname(), details.zone());
        thread.setRemoveLoadingZone(true);
        thread.setGroupowner(details.groupowner());
        thread.setDestination(details.url());
        thread.setOverwrite(details.overwrite() ? LoadingThread.OverwriteBehavior.OVERWRITE : LoadingThread.OverwriteBehavior.FAIL);
        thread.setOverwriteExistingProperties(details.overwriteProperties());
        if (details.zone().getIncomingFiles().size() <= 1) {
            Long createdUriID;
            thread.setCreateManifest(false);
            thread.run();
            ProcessStage stage = thread.getCurrentStatus();
            out.field("status", stage.getStatus().toString().toLowerCase());
            String message = stage.getMessage();
            if (message != null && message.startsWith("<")) {
                out.startObject("message");
                out.field("msg", message, OutputPrinter.FieldOption.XML_COPY);
                out.endObject();
            } else if (message != null) {
                out.field("message", message, OutputPrinter.FieldOption.XML_ELEMENT);
            }
            if (!details.zone().getIncomingFiles().isEmpty() && (createdUriID = details.zone().getIncomingFiles().iterator().next().getUriID()) != null) {
                LoadingZoneUpload.printURIXML(createdUriID, out);
            }
        } else {
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)thread);
            thread.print((OutputPrinter)out);
        }
        return thread;
    }

    public static String generateUploadID() {
        return MD5.hash((String)("PS-UPLOAD" + System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printURIXML(Long id, UniversalPrinter out) {
        String error;
        Database db;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)id);
            out.writeURI(uri);
            tr.commit();
            return;
        }
        catch (QueryFailedException e) {
            error = "Failed to load URI from database: " + e.getMessage();
        }
        catch (StartTransactionException e) {
            error = "Failed to start transaction: " + e.getMessage();
        }
        catch (CommitTransactionException e) {
            error = "Failed to commit transaction: " + e.getMessage();
        }
        finally {
            db.close();
        }
        out.startObject("uri");
        out.field("error", error);
        out.endObject();
    }

    public static Map<String, String> getParameters(HttpServletRequest req) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration paramNames = req.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            params.put(name, req.getParameter(name));
        }
        return params;
    }

    public static List<IncomingFile> createFromMultipart(LoadingZone zone, Collection<FileItem> items, Map<String, String> folders, boolean overwrite, boolean inComment, boolean admin) throws UploadException {
        ArrayList<IncomingFile> files = new ArrayList<IncomingFile>();
        for (FileItem item : items) {
            IncomingFile file;
            LOGGER.debug("parsing: {}", (Object)item.getFieldName());
            if (item.isFormField()) continue;
            LOGGER.debug("found: {} [{}]", (Object)item.getName(), (Object)item.getContentType());
            String filename = item.getName().replace('\\', '/');
            int slash = filename.lastIndexOf(47);
            if (slash != -1) {
                filename = filename.substring(slash + 1);
            }
            String folder = folders.get(item.getFieldName().replace("file-", "folder-"));
            Object location = "";
            if (!(folder == null || folder.isEmpty() || ROOT_FOLDER.equals(folder) || folder.endsWith(ROOT_FOLDER))) {
                location = folder + ROOT_FOLDER;
            }
            if ((file = zone.newFile((String)location + filename)).exists() && !overwrite) {
                throw new UploadException(409, "Destination file already exists and overwrite is set to false");
            }
            if (file.getExtension() != null) {
                String extension = file.getExtension().toLowerCase();
                if (inComment && extension.equals("psml")) {
                    throw new UploadException(400, "PSML files can't be attached");
                }
                if (inComment && RuleUtils.forbiddenAttachmentExtensions().contains(extension)) {
                    throw new UploadException(400, "Files with extension ." + extension + " can't be attached as they may be harmful");
                }
                if (!admin && RuleUtils.forbiddenUploadExtensions().contains(extension)) {
                    throw new UploadException(400, "Files with extension ." + extension + " can only be uploaded by administrators as they may be harmful");
                }
            }
            if (inComment) {
                zone.loadExistingFiles();
            }
            if (inComment && LoadingZoneUpload.tooManyFiles(zone)) {
                throw new UploadException(400, "Maximum number of files has been reached");
            }
            LOGGER.debug("destination: {}", (Object)file);
            try (InputStream in = item.getInputStream();){
                file.save(in);
            }
            catch (IOException ex) {
                throw new UploadException(500, "Failed to save new file: " + ex.getMessage());
            }
            if ("zip".equalsIgnoreCase(file.getExtension()) && LoadingZoneUpload.isInvalidZip(file.getFile())) {
                file.getFile().delete();
                continue;
            }
            try {
                if (file.isMetadataPSML()) {
                    File original = Files.descendantFile((File)zone.baseDirectory(), (String)file.getPath().replaceAll("(^meta-inf/)|(^META-INF/)|(\\.psml$)|(\\.PSML$)", ""));
                    if (original.exists() && original.isFile()) {
                        FileAttributes.clear((File)original);
                    }
                } else {
                    file.checkMetadataFile(zone);
                    file.inspect(zone);
                }
                files.add(file);
            }
            catch (IOException ex) {
                throw new UploadException(400, ex.getMessage());
            }
        }
        return files;
    }

    public static String validateGroup(String nameOrId, Database db, HttpServletResponse res) throws IOException, QueryFailedException {
        Group group;
        boolean isId;
        boolean bl = isId = nameOrId != null && Character.isDigit(nameOrId.charAt(0));
        Group group2 = nameOrId == null ? null : (group = isId ? DatabaseQuery.getGroupById((Database)db, (Long)Long.parseLong(nameOrId)) : DatabaseQuery.getGroupByName((Database)db, (String)nameOrId));
        if (group == null) {
            res.sendError(400, "Group parameter cannot be resolved as a group");
            return null;
        }
        return group.getName();
    }

    public static boolean checkPutPreconditions(HttpServletRequest req, HttpServletResponse res) throws IOException {
        long maxLength;
        if (req.getHeader("Content-Length") == null) {
            res.sendError(411, "HTTP header 'Content-Length' is required");
            return false;
        }
        long length = HttpRequests.getLongHeader((HttpServletRequest)req, (String)"Content-Length");
        if (length > (maxLength = LoadingZoneUpload.getMaxUploadSize())) {
            res.sendError(413, LoadingZoneUpload.lengthExceededMessage());
            HttpRequests.consumeInputStream((HttpServletRequest)req);
            return false;
        }
        if (req.getHeader(FILENAME_HEADER) == null && req.getParameter(FILENAME_PARAMETER) == null) {
            res.sendError(400, "File must be specified via HTTP header or parameter");
            return false;
        }
        if (req.getParameter(GROUP_PARAMETER) == null) {
            res.sendError(400, "Parameter 'group' is required");
            return false;
        }
        return true;
    }

    public static List<FileItem> parseRequest(FileItemFactory factory, HttpServletRequest req) throws FileUploadException {
        ServletFileUpload upload = new ServletFileUpload(factory);
        upload.setSizeMax(LoadingZoneUpload.getMaxUploadSize());
        upload.setFileCountMax(10000L);
        return upload.parseRequest(req);
    }

    public static boolean isInvalidZip(File zipFile) {
        ZipChecker checker = new ZipChecker(zipFile);
        checker.check();
        if (checker.hasError()) {
            LOGGER.warn("Ignoring malicious/invalid ZIP file: {}", (Object)checker.getError());
            return true;
        }
        return false;
    }

    public static long getMaxUploadSize() {
        return GlobalSettings.getLong((String)"maxUploadSize", (long)100000000L);
    }

    public static String lengthExceededMessage() {
        long maxLength = LoadingZoneUpload.getMaxUploadSize();
        return "Content length exceeds " + LoadingZoneUpload.prettySize(maxLength);
    }

    private static String prettySize(long size) {
        if (size > 1000000L) {
            return String.format("%.1f", (double)size / 1000.0 / 1000.0) + "MB";
        }
        if (size > 1000L) {
            return String.format("%.1f", (double)size / 1000.0) + "KB";
        }
        return size + " bytes";
    }

    public static final class RequestDetails {
        private final String username;
        private final Long memberid;
        private final boolean contributor;
        private final String groupowner;
        private final Long groupid;
        private final String groupname;
        private final LoadingZone zone;
        private final boolean overwrite;
        private final boolean overwriteProperties;
        private final URL url;

        public RequestDetails(String name, Long memberId, boolean contrib, URL url, Long groupId, String groupName, String owner, boolean overwrite, boolean overwriteProperties, LoadingZone zone) {
            this.contributor = contrib;
            this.url = url;
            this.groupid = groupId;
            this.groupname = groupName;
            this.groupowner = owner;
            this.overwrite = overwrite;
            this.overwriteProperties = overwriteProperties;
            this.username = name;
            this.memberid = memberId;
            this.zone = zone;
        }

        public LoadingZone zone() {
            return this.zone;
        }

        public URL url() {
            return this.url;
        }

        public Long groupid() {
            return this.groupid;
        }

        public String groupname() {
            return this.groupname;
        }

        public String groupowner() {
            return this.groupowner;
        }

        public String username() {
            return this.username;
        }

        public Long memberid() {
            return this.memberid;
        }

        public boolean contributor() {
            return this.contributor;
        }

        public boolean overwrite() {
            return this.overwrite;
        }

        public boolean overwriteProperties() {
            return this.overwriteProperties;
        }
    }
}

