/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.servlets;

import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.load.LoadingZone;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI(value=PublicAPI.Support.SUPPORTED)
public final class LoadingZoneGet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadingZoneGet.class);
    private static final long serialVersionUID = 4958201084153735921L;
    private static final int BUFFER_SIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        WebRequest wr = new WebRequest(req, res);
        wr.ensureUtf8Request();
        String groupNameOrId = wr.getParameter("group", true);
        if (groupNameOrId == null) {
            return;
        }
        String path = wr.getParameter("path", true);
        if (path == null) {
            return;
        }
        Database db = wr.getDatabase();
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            String xlinkid;
            tr.begin();
            Permissions perm = new Permissions();
            Group group = GroupRule.getGroup((Database)db, (String)groupNameOrId);
            if (group == null) {
                wr.sendError(404, "Group not found");
                tr.abort();
                return;
            }
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new EditURICheck(group))) {
                tr.abort();
                return;
            }
            Long memberId = perm.getMemberId();
            assert (memberId != null);
            Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
            assert (member != null);
            String uploadidParam = req.getParameter("uploadid");
            String uploadid = LoadingZone.getUploadID(uploadidParam, xlinkid = req.getParameter("xlinkid"), db, member);
            if (uploadid == null && (uploadidParam != null || xlinkid != null)) {
                wr.sendError(400, "Invalid uploadid or xlinkid");
                return;
            }
            LoadingZone zone = new LoadingZone(group.getName(), group.getOwnerDirectory(), member.getId(), uploadid);
            File toget = zone.existingFile(path).getFile();
            if (!toget.getCanonicalPath().startsWith(zone.baseDirectory().getCanonicalPath())) {
                LOGGER.error("Path is outside base folder: {}", (Object)toget.getPath());
                throw new IOException("Path is outside base folder");
            }
            if (!toget.exists() || !toget.isFile()) {
                wr.sendError(404, "File path not found");
                tr.abort();
                return;
            }
            this.serveFile(toget, req, res);
            tr.commit();
        }
        catch (StartTransactionException ex) {
            wr.sendError((Exception)((Object)ex));
        }
        catch (Exception ex) {
            tr.abort();
            wr.sendError(ex);
        }
        finally {
            db.close();
            db = null;
        }
    }

    private void serveFile(File file, HttpServletRequest req, HttpServletResponse res) throws IOException {
        long modifiedSince = req.getDateHeader("If-Modified-Since");
        long lastModified = file.lastModified();
        if (modifiedSince != -1L && lastModified != 0L && lastModified <= modifiedSince + 1000L) {
            res.setStatus(304);
            return;
        }
        res.setContentType(Medias.getMediaType((String)URIRule.getFilename((String)file.getName())[1]));
        if (lastModified != 0L) {
            res.setDateHeader("Last-Modified", lastModified);
        }
        res.setHeader("Content-Disposition", HttpRequests.toSafeHeader((String)("attachment; filename=\"" + file.getName() + "\"")));
        ServletOutputStream outs = res.getOutputStream();
        try (FileInputStream ins = new FileInputStream(file);){
            int i;
            res.setContentLength(((InputStream)ins).available());
            byte[] buff = new byte[2048];
            do {
                if ((i = ((InputStream)ins).read(buff, 0, 2048)) <= 0) continue;
                outs.write(buff, 0, i);
            } while (i == 2048);
        }
    }
}

