/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.generators;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.load.LoadingZone;
import java.io.IOException;

@Requires(group=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class LoadingZoneAsTree
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        String uploadid = req.getParameter((Parameter)StandardParameters.uploadid);
        long xlinkid = req.getParameter((Parameter)StandardParameters.xlinkid, -1L);
        if (uploadid == null && xlinkid > 0L) {
            return new ViewMemberCheck(req.getMember());
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String uploadid;
        try {
            uploadid = LoadingZone.getUploadID(req, res);
            if (uploadid != null && uploadid.isEmpty()) {
                return;
            }
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load upload ID: " + ex.getMessage());
            return;
        }
        LoadingZone zone = new LoadingZone(req.getGroup().getName(), req.getGroup().getOwnerDirectory(), req.getMember().getId(), uploadid);
        UniversalPrinter out = res.getUniversalWriter();
        out.write(zone.printable(true, false));
        out.flush();
    }
}

