/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.edits;

import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.Immutable;
import com.pageseeder.common.util.Strings;
import com.pageseeder.load.edits.ContentPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class Fragment {
    private @Nullable String sectionId = null;
    private final String fragmentId;
    private String contentType;
    private final List<ContentPart> parts = new ArrayList<ContentPart>();
    private @Nullable StringBuilder contents = null;
    private @Nullable StringBuilder comparisonContents = null;
    private final List<XRef> xrefs = new ArrayList<XRef>();
    private @Nullable Long editXLinkID = null;
    private boolean isDeleted = false;
    private boolean hasModifiedXRefs = false;
    private @Nullable String labels = null;
    private final List<Note> notes = new ArrayList<Note>();

    public Fragment(String fragmentId, String contentType) {
        this.fragmentId = fragmentId;
        this.contentType = contentType;
    }

    public void setSectionId(String sectId) {
        this.sectionId = sectId;
    }

    public void setEditXLinkID(String xlinkid) {
        try {
            this.editXLinkID = Long.parseLong(xlinkid);
        }
        catch (NumberFormatException ex) {
            this.editXLinkID = null;
        }
    }

    public @Nullable String getLabels() {
        return this.labels;
    }

    public void setLabels(String labs) {
        if (!Strings.isEmpty((String)labs)) {
            this.labels = labs;
        }
    }

    public void addNote(String title, @Nullable String content, @Nullable String labs) {
        Note note = new Note(title, content, labs);
        this.notes.add(note);
    }

    public @Nullable Note getNote(int index) {
        if (index >= this.notes.size()) {
            return null;
        }
        return this.notes.get(index);
    }

    public boolean hasNote(@Nullable Note note) {
        if (note == null) {
            return false;
        }
        return this.notes.contains(note);
    }

    public @Nullable String sectionId() {
        return this.sectionId;
    }

    public boolean hasEditXLink() {
        return this.editXLinkID != null;
    }

    public @Nullable Long getEditXlinkID() {
        return this.editXLinkID;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public void setContentType(String contenttype) {
        this.contentType = contenttype;
        this.unescapeXML(this.contents);
        this.unescapeXML(this.comparisonContents);
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void addContents(List<ContentPart> allparts) {
        this.parts.addAll(allparts);
    }

    public void addXref(XRef xref) {
        this.xrefs.add(xref);
    }

    public StringBuilder getContents() {
        if (this.contents == null) {
            this.computeContents();
        }
        return this.contents;
    }

    public StringBuilder getComparisonContents() {
        if (this.comparisonContents == null) {
            this.computeContents();
        }
        return this.comparisonContents;
    }

    private void computeContents() {
        this.contents = new StringBuilder();
        this.comparisonContents = new StringBuilder();
        for (ContentPart part : this.parts) {
            this.contents.append(part.toString());
            this.comparisonContents.append(part.toComparisonString());
        }
        this.unescapeXML(this.contents);
        this.unescapeXML(this.comparisonContents);
    }

    public void setHasModifiedXRefs(boolean hasXRefs) {
        this.hasModifiedXRefs = hasXRefs;
    }

    public boolean hasModifiedXRefs() {
        return this.hasModifiedXRefs;
    }

    public void removeXRef(XRef xref) {
        this.xrefs.remove(xref);
    }

    public List<XRef> getXRefs() {
        return this.xrefs;
    }

    public String getFragment() {
        return this.fragmentId;
    }

    public String toString() {
        return this.contents == null ? "" : this.contents.toString();
    }

    private void unescapeXML(@Nullable StringBuilder xml) {
        if (xml != null && "text/plain".equals(this.contentType)) {
            int max = xml.length();
            for (int i = 0; i < max; ++i) {
                char c = xml.charAt(i);
                if (c != '&') continue;
                if (xml.length() >= i + 5 && "&amp;".equals(xml.substring(i, i + 5))) {
                    xml.replace(i, i + 5, "&");
                    max -= 4;
                    continue;
                }
                if (xml.length() >= i + 4 && "&lt;".equals(xml.substring(i, i + 4))) {
                    xml.replace(i, i + 4, "<");
                    max -= 3;
                    continue;
                }
                if (xml.length() < i + 4 || !"&gt;".equals(xml.substring(i, i + 4))) continue;
                xml.replace(i, i + 4, ">");
                max -= 3;
            }
        }
    }

    @Immutable
    protected static final class Note {
        private final @Nullable String title;
        private final @Nullable String content;
        private final @Nullable String labels;
        private int hash = 0;

        public Note(String title, @Nullable String content, @Nullable String labels) {
            this.title = title;
            this.content = content;
            this.labels = labels;
        }

        public @Nullable String title() {
            return this.title;
        }

        public @Nullable String content() {
            return this.content;
        }

        public @Nullable String labels() {
            return this.labels;
        }

        public int hashCode() {
            if (this.hash == 0) {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
                result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
                this.hash = result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Note n = (Note)obj;
            if (this.title != null ? !this.title.equals(n.title) : n.title != null) {
                return false;
            }
            if (this.content != null ? !this.content.equals(n.content) : n.content != null) {
                return false;
            }
            return !(this.labels != null ? !this.labels.equals(n.labels) : n.labels != null);
        }
    }
}

