/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingThreadAction;
import com.pageseeder.validation.SchematronValidationManager;
import com.pageseeder.validation.ValidationResults;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;

public final class ValidateSchematron
implements LoadingThreadAction {
    private final LoadingThread parent;
    private int total = 0;
    private int alreadyDone = 0;
    private boolean cancelled = false;

    public ValidateSchematron(LoadingThread dad) {
        this.parent = dad;
    }

    @Override
    public String name() {
        return "ValidateSchematron";
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("action");
        out.field("current", (long)this.alreadyDone);
        out.field("total", (long)this.total);
        out.field("name", this.name(), OutputPrinter.FieldOption.XML_TEXT);
        out.endObject();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Collection<IncomingFile> files) {
        Database db;
        this.total = files.size();
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException e) {
            this.parent.fail("Failed to open the database:" + e.getMessage());
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            if (this.cancelled) {
                tr.abort();
                return;
            }
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.parent.getGroupID());
            Member uploader = DatabaseQuery.getMemberByUsername((Database)db, (String)this.parent.getUsername());
            SchematronValidationManager validator = SchematronValidationManager.getInstance();
            HashMap<String, String> cache = new HashMap<String, String>();
            for (IncomingFile file : files) {
                ++this.alreadyDone;
                URI uri = DatabaseQuery.getURIById((Database)db, (Long)file.getUriID());
                if (!URIRule.isPSML((URI)uri)) continue;
                ValidationResults results = validator.getValidationResults(group, uri, uploader, db, cache);
                if (this.cancelled) {
                    tr.abort();
                    return;
                }
                if (results.wasSchemaNotFound()) continue;
                if (results.hasError()) {
                    if (results.getErrorMessage() != null) {
                        this.parent.updateStatus(ProcessStage.Status.WARNING, "Error validating " + file.getPath() + " with default schematron (URIID " + uri.getId() + ")");
                        this.parent.updateStatus(ProcessStage.Status.WARNING, results.getErrorMessage());
                        continue;
                    }
                    List<String> asserts = results.listFailedAssertions();
                    this.parent.updateStatus(ProcessStage.Status.WARNING, "Found " + asserts.size() + " error" + (asserts.size() == 1 ? "" : "s") + " validating " + file.getPath() + " with default schematron (URIID " + uri.getId() + ")");
                    for (String assertion : asserts) {
                        this.parent.updateStatus(ProcessStage.Status.WARNING, assertion);
                    }
                    continue;
                }
                this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "Found no errors validating " + file.getPath() + " with default schematron (URIID " + uri.getId() + ")");
            }
            tr.commit();
        }
        catch (DatabaseException ex) {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to perform schematron validation: " + ex.getMessage());
            tr.abort();
        }
        finally {
            db.close();
            db = null;
        }
    }
}

