/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.FileAttributes;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.db.model.Group;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingZone;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class UnzipThread
extends ProcessThread {
    private final File toUnzip;
    private final LoadingZone zone;
    private final boolean admin;
    private int alreadyUnzipped = 0;
    private int totalNb = 0;
    private int warnings = 0;
    private int ignored = 0;
    private boolean isRunning = false;
    private boolean overwrite = true;
    private boolean deleteOriginal = false;

    private UnzipThread(String username, Group group, File zip, LoadingZone lzone, boolean admin) {
        super(username, "Unzipping '" + zip.getName() + "' in loading zone", group);
        this.toUnzip = zip;
        this.zone = lzone;
        this.admin = admin;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setDeleteOriginal(boolean deleteOriginal) {
        this.deleteOriginal = deleteOriginal;
    }

    public void process() {
        try {
            this.isRunning = true;
            this.unzip(StandardCharsets.UTF_8);
            if (this.deleteOriginal && !this.wasCancelled() && this.getFailMessage() == null) {
                this.toUnzip.delete();
            }
        }
        catch (IOException ex) {
            this.fail("Unzip Thread failed: " + ex.getMessage());
        }
        finally {
            this.isRunning = false;
            String msg = "Successfully unzipped " + this.alreadyUnzipped + " files/folders";
            if (this.ignored > 0) {
                msg = msg + " (" + this.ignored + " local/external files ignored)";
            }
            if (this.warnings > 0) {
                msg = msg + " with " + this.warnings + " warnings";
            }
            if (this.ignored > 0 || this.warnings > 0) {
                msg = msg + ", see logs for more info";
            }
            this.complete(msg + ".");
        }
    }

    private void unzip(Charset encoding) throws IOException {
        ZipFile zip = new ZipFile(this.toUnzip, encoding);
        try {
            ArrayList<File> created = new ArrayList<File>();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            ArrayList<ZipEntry> allEntries = new ArrayList<ZipEntry>();
            try {
                while (entries.hasMoreElements()) {
                    allEntries.add(entries.nextElement());
                }
            }
            catch (Exception ex) {
                if ("MALFORMED".equals(ex.getMessage()) && StandardCharsets.UTF_8.equals(encoding)) {
                    try {
                        this.unzip(Charset.forName("CP437"));
                    }
                    catch (UnsupportedCharsetException ex2) {
                        this.unzip(StandardCharsets.ISO_8859_1);
                    }
                } else {
                    this.fail("Invalid Zip file, PageSeeder cannot read the file because of a suspicious encoding");
                }
                zip.close();
                return;
            }
            this.totalNb = allEntries.size();
            ArrayList<IncomingFile> metadataFiles = new ArrayList<IncomingFile>();
            Collection forbidden = RuleUtils.forbiddenUploadExtensions();
            for (ZipEntry entry : allEntries) {
                if (this.checkCancelled(created)) {
                    return;
                }
                if (this.ignoreLocalExternalEntry(entry.getName())) {
                    ++this.ignored;
                    this.updateStatus(ProcessStage.Status.WARNING, "'" + entry.getName() + "' was ignored");
                    continue;
                }
                if (this.ignoreZipEntry(entry.getName())) {
                    ++this.warnings;
                    this.updateStatus(ProcessStage.Status.WARNING, "'" + entry.getName() + "' was ignored");
                    continue;
                }
                String validName = RuleUtils.replaceNonFolderCharsKeepSlashes((String)entry.getName().replace('\\', '/'));
                String extension = URIRule.getExtension((String)validName).toLowerCase();
                if (!this.admin && forbidden.contains(extension)) {
                    this.revert(created);
                    this.fail("'" + entry.getName() + "' can only be unzipped by an administrator as it may be harmful");
                    return;
                }
                File newFile = new File(this.zone.baseDirectory(), validName);
                if (newFile.exists() && !this.overwrite) {
                    ++this.warnings;
                    this.updateStatus(ProcessStage.Status.WARNING, "Destination file '" + validName + "' already exists and overwrite is off");
                    continue;
                }
                if (this.checkCancelled(created)) {
                    return;
                }
                File parent = newFile.getParentFile();
                while (!parent.exists()) {
                    created.add(parent);
                    parent = parent.getParentFile();
                }
                newFile.getParentFile().mkdirs();
                if (!newFile.exists()) {
                    if (entry.isDirectory()) {
                        if (!newFile.mkdir()) {
                            ++this.warnings;
                            this.updateStatus(ProcessStage.Status.WARNING, "Failed to create new file '" + validName + "'");
                            continue;
                        }
                    } else if (!newFile.createNewFile()) {
                        ++this.warnings;
                        this.updateStatus(ProcessStage.Status.WARNING, "Failed to create new file '" + validName + "'");
                        continue;
                    }
                    created.add(newFile);
                }
                if (!entry.isDirectory()) {
                    try (InputStream in = zip.getInputStream(entry);){
                        if (in == null) {
                            this.fail("Invalid Zip file, PageSeeder cannot read the file");
                            return;
                        }
                        if (this.checkCancelled(created)) {
                            return;
                        }
                        try (FileOutputStream os = new FileOutputStream(newFile);){
                            int buffersize = 8192;
                            byte[] buffer = new byte[8192];
                            int read = in.read(buffer);
                            while (read != -1 && !this.wasCancelled()) {
                                ((OutputStream)os).write(buffer, 0, read);
                                read = in.read(buffer);
                            }
                        }
                    }
                }
                if (this.checkCancelled(created)) {
                    return;
                }
                IncomingFile ifile = new IncomingFile(newFile, entry.getName(), this.zone);
                this.zone.addIncomingFile(ifile);
                if (ifile.isMetadataPSML()) {
                    metadataFiles.add(ifile);
                }
                ++this.alreadyUnzipped;
            }
            for (IncomingFile metadata : metadataFiles) {
                IncomingFile file = this.zone.getCorrespondingNonMetadataFile(metadata);
                if (file == null) continue;
                FileAttributes.clear((File)file.getFile());
            }
        }
        finally {
            try {
                zip.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    private boolean ignoreZipEntry(String name) {
        return name.matches("(^\\..{0,500}$)|(^.{0,500}?/\\..{0,500}$)|(^/?__MACOSX/.{0,500}$)|(^.{0,500}?/\\.DS_Store$)");
    }

    private boolean ignoreLocalExternalEntry(String name) {
        return name.matches("^/?_(external|local|External|Local)/.{0,500}$");
    }

    public static UnzipThread newInstance(String username, Group group, File zip, LoadingZone lzone, boolean admin) {
        return new UnzipThread(username, group, zip, lzone, admin);
    }

    private boolean checkCancelled(List<File> created) {
        boolean cancelled = this.wasCancelled();
        if (cancelled) {
            this.revert(created);
        }
        return cancelled;
    }

    private void revert(List<File> created) {
        List files = created.stream().filter(File::isFile).collect(Collectors.toList());
        for (File f : files) {
            f.delete();
        }
        List folders = created.stream().filter(File::isDirectory).sorted(Comparator.comparing(File::getAbsolutePath).reversed()).collect(Collectors.toList());
        for (File f : folders) {
            f.delete();
        }
    }

    public void writeThreadElements(OutputPrinter out) {
        if (this.isRunning) {
            out.startObject("action");
            out.field("current", (long)this.alreadyUnzipped);
            out.field("total", (long)this.totalNb);
            out.field("name", "Unzip", OutputPrinter.FieldOption.XML_TEXT);
            out.endObject();
        }
    }
}

