/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.Labels;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingThreadAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class SendNotification
implements LoadingThreadAction {
    private static final int MAX_UPLOAD_NOTIFICATION_ATTACHMENTS = 20;
    private final LoadingThread parent;
    private boolean cancelled = false;
    private StringBuilder message = new StringBuilder("The file has been uploaded.");
    private final List<String> warnings = new ArrayList<String>();
    private String subject = "File Upload";
    private @Nullable String status = null;
    private String @Nullable [] labels = null;
    private Notify notify = Notify.SILENT;
    private boolean done = false;
    private Long destinationFolderURIID = -1L;

    public SendNotification(LoadingThread thread) {
        this.parent = thread;
    }

    public void setDestinationFolderURIID(Long destinationFolderURIID) {
        this.destinationFolderURIID = destinationFolderURIID;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void setMessage(String message) {
        this.message = new StringBuilder(message);
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSubject(String subject) {
        this.subject = Strings.isEmpty((String)subject) ? "File Upload" : subject;
    }

    public void setNotify(String notify) {
        this.notify = Notify.fromString((String)notify);
    }

    public String @Nullable [] getLabels() {
        return this.labels;
    }

    @Override
    public String name() {
        return "Notification";
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("action");
        out.field("current", this.done ? 1L : 0L);
        out.field("total", 1L);
        out.field("name", this.name(), OutputPrinter.FieldOption.XML_TEXT);
        out.endObject();
    }

    public void addWarning(@Nullable String warning) {
        this.warnings.add(warning);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(Collection<IncomingFile> files) {
        try {
            Database db;
            block26: {
                db = Database.open();
                if (!this.cancelled) break block26;
                if (db == null) return;
                db.close();
                return;
            }
            try {
                Group grp;
                Member member;
                boolean linkURIs;
                ArrayList<URI> attachments;
                Transaction tr;
                block27: {
                    tr = new Transaction(db);
                    tr.begin();
                    attachments = new ArrayList<URI>();
                    int maxAttachments = GlobalSettings.getInt((String)"maxUploadNotificationAttachments", (int)20);
                    boolean bl = linkURIs = files.size() <= maxAttachments;
                    if (!linkURIs) {
                        this.message.append("\n\nThere were ").append(files.size());
                        this.message.append(" files which is too many to attach.");
                        if (!this.warnings.isEmpty()) {
                            this.message.append("\n\nThe upload succeeded with ").append(this.warnings.size()).append(" warnings.\n");
                        }
                    }
                    try {
                        member = DatabaseQuery.getMemberByUsername((Database)db, (String)this.parent.getUsername());
                        grp = DatabaseQuery.getGroupById((Database)db, (Long)this.parent.getGroupID());
                        if (linkURIs) {
                            for (IncomingFile file : files) {
                                attachments.add(DatabaseQuery.getURIById((Database)db, (Long)file.getUriID()));
                            }
                        }
                    }
                    catch (QueryFailedException e) {
                        tr.abort();
                        this.parent.fail("Failed to load database object: " + e.getMessage());
                        if (db == null) return;
                        db.close();
                        return;
                    }
                    if (!this.cancelled) break block27;
                    tr.abort();
                    if (db == null) return;
                    db.close();
                    return;
                }
                if (!this.warnings.isEmpty() && linkURIs) {
                    this.message.append("\n\nThe upload succeeded with the following warnings:\n");
                    for (String warning : this.warnings) {
                        this.message.append(warning).append('\n');
                    }
                }
                try {
                    if (this.notify == Notify.NORMAL || this.notify == Notify.ANNOUNCE) {
                        Emails.sendNewURI((Database)db, (Member)member, (String)this.subject, (String)this.message.toString(), (String)"File Upload", (String[])this.labels, attachments, (Group)grp, (this.notify == Notify.ANNOUNCE ? 1 : 0) != 0, (Boolean)false);
                    }
                    this.done = true;
                    Object updateStatus = this.notify == Notify.NORMAL ? "Notification message sent: " : "Notification message attached: ";
                    String updateLabels = Labels.labelsToCommaSeparated((String[])this.labels);
                    updateStatus = (String)updateStatus + this.subject + (String)(updateLabels != null ? " - " + updateLabels : "");
                    this.parent.updateStatus(ProcessStage.Status.INPROGRESS, (String)updateStatus);
                }
                catch (FoundationException ex) {
                    tr.abort();
                    this.parent.fail(ex.getMessage());
                    if (db == null) return;
                    db.close();
                    return;
                }
                try {
                    tr.commit();
                    return;
                }
                catch (Exception ex) {
                    tr.abort();
                    this.parent.fail("Failed to send notification: " + ex.getMessage());
                    return;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        catch (OpenDatabaseException e) {
            this.parent.fail("Failed to open the database:" + e.getMessage());
        }
    }
}

