/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.model.Group;
import com.pageseeder.load.AntScript;
import com.pageseeder.load.LoadingZone;
import org.eclipse.jdt.annotation.Nullable;

public final class PreviewThread
extends ProcessThread {
    private @Nullable AntScript script;

    PreviewThread(String username, Group group, LoadingZone zone) {
        super(username, "Preview", group);
    }

    public void setAntScript(AntScript script) {
        this.script = script;
    }

    public void cancel() {
        super.cancel();
        if (this.script != null) {
            this.script.cancel();
        }
    }

    public void process() {
        if (this.script == null) {
            this.fail("No preview script to run!");
        } else {
            try {
                this.setName("Preview of " + this.script.getProcessedFile().getPath());
                this.script.run();
            }
            catch (Exception ex) {
                this.fail("Loading Thread failed: " + ex.getMessage());
            }
        }
        this.complete("Success!!");
    }

    public void writeThreadElements(OutputPrinter out) {
        if (this.script != null) {
            this.script.print(out);
        }
    }
}

