/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThreadAction;
import com.pageseeder.load.edits.FragmentMediator;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediateFragments
implements LoadingThreadAction {
    private static final Logger GENERAL_LOGGER = LoggerFactory.getLogger(MediateFragments.class);
    private final Map<Long, Boolean> uriids = new HashMap<Long, Boolean>();
    private final List<Long> skipUriids = new ArrayList<Long>();
    private final Map<Long, File> uris = new HashMap<Long, File>();
    private final Map<Long, File> metadatas = new HashMap<Long, File>();
    private final boolean createXRefs;
    private final boolean editMetadata;
    private final String @Nullable [] uriHistoryEventLabels;
    private final Map<Long, IncomingFile> toRevert;
    private final @Nullable URL uploadUrl;
    private final ProcessThread parent;
    private int urisProcessed = 0;
    private boolean cancelled = false;
    private final Set<Long> targetTranscludingUris = new HashSet<Long>();
    private final Set<Long> publicationUpdateUris = new HashSet<Long>();

    public MediateFragments(ProcessThread parent, boolean createXRefs, boolean editMetadata, String @Nullable [] eventLabels, Map<Long, IncomingFile> reverts, @Nullable URL uploadUrl) {
        this.parent = parent;
        this.createXRefs = createXRefs;
        this.editMetadata = editMetadata;
        this.uriHistoryEventLabels = eventLabels;
        this.toRevert = reverts;
        this.uploadUrl = uploadUrl;
    }

    public void addURI(@Nullable Long uriid, boolean justCreated, @Nullable File backup, @Nullable File metadata, boolean skip) {
        if (uriid == null) {
            return;
        }
        this.uriids.put(uriid, !justCreated);
        if (backup != null) {
            this.uris.put(uriid, backup);
        }
        if (metadata != null) {
            this.metadatas.put(uriid, metadata);
        }
        if (skip) {
            this.skipUriids.add(uriid);
        }
    }

    public Set<Long> getTargetTranscludingUris() {
        return this.targetTranscludingUris;
    }

    public Set<Long> getPublicationUpdateUris() {
        return this.publicationUpdateUris;
    }

    @Override
    public String name() {
        return "CreateEdits";
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("action");
        out.field("current", (long)this.urisProcessed);
        out.field("total", (long)this.uriids.size());
        out.field("name", this.name(), OutputPrinter.FieldOption.XML_TEXT);
        out.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.uriids.isEmpty()) {
            this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "No documents to create edits for");
            return;
        }
        if (this.cancelled) {
            return;
        }
        Database db = null;
        Transaction tr = null;
        URI uri = null;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException e) {
            this.parent.fail("Failed to open the database:" + e.getMessage());
            return;
        }
        tr = new Transaction(db);
        try {
            tr.begin();
            Group uploadGroup = DatabaseQuery.getGroupById((Database)db, (Long)this.parent.getGroupID());
            Member author = DatabaseQuery.getMemberByUsername((Database)db, (String)this.parent.getUsername());
            UserDetails userdetails = new UserDetailsManager().get(db, author.getId(), false);
            boolean uriOwner = PermissionManager.check((Long)author.getId(), (UserDetails)userdetails, (Database)db, (Permissions)new Permissions(), (PermissionCheck)new EditAllURLsCheck());
            int counter = 0;
            ArrayList<Long> edited = new ArrayList<Long>();
            for (Long uriid : this.uriids.keySet()) {
                if (this.cancelled) break;
                try {
                    uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                    if (uri == null) {
                        this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to create Edits: Invalid URI ID " + uriid);
                        continue;
                    }
                    File metadata = this.metadatas.get(uri.getId());
                    boolean existing = this.uriids.get(uriid);
                    Member origAuthor = null;
                    if (existing) {
                        List xls = DatabaseQuery.getXLinksByURIModification((Database)db, (Long)uri.getId(), (boolean)true);
                        if (xls.isEmpty()) {
                            origAuthor = author;
                            existing = false;
                        } else if (((XLink)xls.get(0)).getMember() != null) {
                            origAuthor = ((XLink)xls.get(0)).getMember();
                        }
                    } else {
                        origAuthor = author;
                    }
                    if (!(this.skipUriids.contains(uri.getId()) || !URIRule.isPSML((URI)uri) && metadata == null || uri.getExternal().booleanValue() && !uriOwner)) {
                        List<String> warnings;
                        XLink old;
                        Group group = GroupRule.getEditGroup((Database)db, (Group)uploadGroup, (URI)uri);
                        FragmentMediator mediator = new FragmentMediator(group, uri, existing, origAuthor, this.uris.get(uriid), metadata, author, this.uploadUrl, db);
                        mediator.setCreateXRefs(this.createXRefs);
                        mediator.setEditMetadata(this.editMetadata);
                        if (this.cancelled) break;
                        boolean modified = mediator.mediateDocument();
                        XLink structure = DatabaseQuery.getXLinkURIStructureNew((Database)db, (URI)uri, (Group)group);
                        if (structure != null && ((old = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)group, null)) == null || old.getId() < structure.getId())) {
                            if (old != null) {
                                old.setStatus("Documentation-Old");
                            }
                            structure.setStatus(null);
                            modified = true;
                        }
                        if (modified) {
                            uri.setLastModified(new Date());
                            if (URIRule.isPSML((URI)uri)) {
                                this.publicationUpdateUris.add(uri.getId());
                                this.publicationUpdateUris.addAll(mediator.getEmbedTargetUris());
                            }
                        }
                        if (this.cancelled) break;
                        List<String> errors = mediator.getErrors();
                        if (errors != null && !errors.isEmpty()) {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to create Edits for URI " + uri.getDecodedPath() + " (" + uriid + ")");
                            for (String err : errors) {
                                this.parent.updateStatus(ProcessStage.Status.WARNING, err);
                            }
                        }
                        if (!(warnings = mediator.getWarnings()).isEmpty()) {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Found " + warnings.size() + " warning" + (warnings.size() == 1 ? "" : "s") + " when creating Edits for URI " + uri.getDecodedPath() + " (" + uriid + ")");
                            for (String w : warnings) {
                                this.parent.updateStatus(ProcessStage.Status.WARNING, w);
                            }
                        }
                        this.targetTranscludingUris.addAll(mediator.getTargetTranscludingUris());
                        if (modified) {
                            this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "Created Edits for URI " + uri.getDecodedPath() + " (" + uriid + ")");
                        }
                    }
                    ++this.urisProcessed;
                    if (!uri.isExternal()) {
                        File file = new File(URIRule.getRealPath((String)uri.getPath()));
                        byte[] content = !existing && URIRule.isPSML((URI)uri) ? Files.readAllBytes(file.toPath()) : null;
                        URIRule.addURIHistoryXLink((URI)uri, (Member)author, (Date)uri.getDateCreated(), null, (String)"upload", (String[])this.uriHistoryEventLabels, null, null, (byte[])content, (Database)db);
                    }
                    edited.add(uri.getId());
                    if (counter++ != 1000) continue;
                    tr.commitAndStart();
                    for (Long uid : edited) {
                        this.toRevert.remove(uid);
                    }
                    edited.clear();
                    counter = 0;
                }
                catch (Throwable ex) {
                    String msg = uri == null ? String.valueOf(uriid) : uri.getDecodedPath() + " (" + uriid + ")";
                    this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to create Edits for URI " + msg + ": " + ex.getMessage());
                    GENERAL_LOGGER.error("Failed to create edits for URI {}", (Object)uriid, (Object)ex);
                }
            }
            if (this.cancelled) {
                tr.abort();
            } else {
                tr.commit();
            }
        }
        catch (DatabaseException ex) {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Database error: " + ex.getMessage());
            GENERAL_LOGGER.error("Database error", (Throwable)ex);
        }
        finally {
            db.close();
            db = null;
        }
    }
}

