/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.security.MalwareScanner;
import com.pageseeder.base.security.ScanResult;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.util.FileAttributes;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingThreadAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class MalwareScan
implements LoadingThreadAction {
    private final LoadingThread parent;
    private int total = 0;
    private int alreadyDone = 0;
    private boolean cancelled = false;

    MalwareScan(LoadingThread dad) {
        this.parent = dad;
    }

    @Override
    public String name() {
        return "Scan";
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("action");
        out.field("current", (long)this.alreadyDone);
        out.field("total", (long)this.total);
        out.field("name", this.name(), OutputPrinter.FieldOption.XML_TEXT);
        out.endObject();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void run(@Nullable Collection<IncomingFile> files) {
        MalwareScanner client = SecurityUtils.getMalwareClient();
        if (client == null || files == null || files.isEmpty()) {
            return;
        }
        ArrayList<IncomingFile> sfiles = new ArrayList<IncomingFile>();
        for (IncomingFile file : files) {
            if ("xml".equalsIgnoreCase(file.getExtension()) || "psml".equalsIgnoreCase(file.getExtension())) continue;
            sfiles.add(file);
        }
        if (sfiles.isEmpty()) {
            return;
        }
        this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "Scanning files for malware.");
        this.total = sfiles.size();
        for (IncomingFile file : sfiles) {
            if (file.getFile().isFile() && (!this.scan(file, client) || this.cancelled)) break;
            ++this.alreadyDone;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean scan(IncomingFile file, MalwareScanner client) {
        Map<String, String> atts = file.getAttributes();
        String malware = atts.get("malware");
        if ("no-threat".equals(malware)) {
            this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "File " + file.getFile().getName() + " scanned OK previously.");
            return true;
        }
        if ("threat".equals(malware)) {
            this.parent.fail("Malware found previously in file " + file.getPath());
            return false;
        }
        try (FileInputStream is = new FileInputStream(file.getFile());){
            ScanResult result = client.scan((InputStream)is);
            if (ScanResult.Status.OK.equals((Object)result.getStatus())) {
                this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "File " + file.getFile().getName() + " scanned OK.");
                atts.put("malware", "no-threat");
                FileAttributes.putAttributes((File)file.getFile(), atts);
                boolean bl = true;
                return bl;
            }
            if (ScanResult.Status.VIRUS_FOUND.equals((Object)result.getStatus())) {
                this.parent.fail("Malware " + result.getSignature() + " found in file " + file.getPath());
                atts.put("malware", "threat");
                FileAttributes.putAttributes((File)file.getFile(), atts);
                return false;
            }
            this.parent.fail("Error scanning file " + file.getPath() + ": " + result.getOutput());
            return false;
        }
        catch (Exception ex) {
            this.parent.fail("Malware scanning failed: " + ex.getMessage());
        }
        return false;
    }
}

