/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.label;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelConfigManager;
import com.pageseeder.base.label.LabelInfo;
import com.pageseeder.base.label.LabelType;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Group;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

@Requires(group=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class SaveLabelConfig
implements Generator,
SingleCheck {
    @ContentPermission(value=ConfigureProjectCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ConfigureProjectCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Logger logger = req.getLogger((Object)this);
        Group group = req.getGroup();
        String owner = group.getOwnerDirectory();
        logger.debug("Owner: {}", (Object)owner);
        try {
            LabelConfig config = null;
            boolean useDefault = "true".equals(req.getParameter((Parameter)StandardParameters.use_default));
            if (owner != null && SaveLabelConfig.isValidOwner(group, owner)) {
                Object f;
                if (useDefault) {
                    f = LabelConfigManager.getConfigFile((Group)group);
                    logger.info("Deleting label config file: {}", (Object)((File)f).getAbsolutePath());
                    SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.CONFIGURATION_CHANGE, (String)"Label configuration for {} was reverted to default", (Object[])new Object[]{group.getName()});
                    if (((File)f).exists()) {
                        ((File)f).delete();
                    }
                } else {
                    for (LabelType type : LabelType.values()) {
                        String infos = req.getParameter(type.key() + "-label");
                        if (infos == null) continue;
                        ArrayList<LabelInfo> labels = new ArrayList<LabelInfo>();
                        for (String info : infos.split("(?<!\\\\),")) {
                            if (info.isEmpty()) continue;
                            labels.add(SaveLabelConfig.toLabelInfo(info));
                        }
                        if (config == null) {
                            config = new LabelConfig(owner);
                        }
                        config.set(type, labels);
                    }
                    if (config != null) {
                        f = LabelConfigManager.getConfigFile((Group)group);
                        logger.info("Saving label config file: {}", (Object)((File)f).getAbsolutePath());
                        LabelConfigManager.save((File)f, (LabelConfig)config);
                        SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.CONFIGURATION_CHANGE, (String)"Label configuration for {} was modified", (Object[])new Object[]{group.getName()});
                    }
                }
            }
            if (config == null) {
                config = LabelConfigManager.getLabelConfig((String)owner);
            }
            UniversalPrinter out = res.getUniversalWriter();
            config.print((OutputPrinter)out);
            out.flush();
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    private static LabelInfo toLabelInfo(String info) {
        String[] data = info.split("(?<!\\\\):");
        String name = SaveLabelConfig.unescapeLabelString(data[0]);
        String description = data.length > 1 ? SaveLabelConfig.unescapeLabelString(data[1]) : null;
        String color = data.length > 2 ? SaveLabelConfig.unescapeLabelString(data[2]) : null;
        LabelInfo label = new LabelInfo(name, description);
        label.setColor(color);
        return label;
    }

    private static boolean isValidOwner(Group group, String owner) {
        return group.getName().equals(owner) || group.getName().startsWith(owner + "-");
    }

    private static String unescapeLabelString(String s) {
        return s.replaceAll("\\\\([,:])", "$1");
    }
}

