/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.host;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.HostAlias;
import com.pageseeder.host.Hosts;
import java.io.IOException;

@Requires(parameters={"name"})
@Output(types={OutputType.XML, OutputType.JSON})
public class EditHostalias
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        String aliasName = req.getParameter((Parameter)StandardParameters.name);
        String newAliasName = req.getParameter((Parameter)StandardParameters.new_name);
        assert (aliasName != null);
        HostAlias alias = DatabaseQuery.getHostAliasByName((Database)db, (String)(aliasName = aliasName.toLowerCase()));
        if (alias == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Host alias " + aliasName + " was not found.");
            return;
        }
        if (newAliasName != null) {
            if (!Hosts.checkHostName(newAliasName = newAliasName.toLowerCase(), res)) {
                return;
            }
            if (DatabaseQuery.getHostByName((Database)db, (String)newAliasName) != null || DatabaseQuery.getHostAliasByName((Database)db, (String)newAliasName) != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "The host alias name is already in use.");
                return;
            }
            alias.setName(newAliasName);
        }
        SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.CONFIGURATION_CHANGE, (String)"Host alias {} ({}) was modified", (Object[])new Object[]{aliasName, alias.getId()});
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("alias-modification");
        out.startObject("alias");
        out.field("id", alias.getId().longValue());
        out.field("name", alias.getName());
        out.endObject();
        out.endObject();
        out.flush();
    }
}

