/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.groupfolder;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.groupfolder.GroupFolderErrorID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListGroupFoldersForPath
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListGroupFoldersForPath.class);
    private static final Comparator<GroupURI> PATH_ALPHABETICAL_ORDER = (guri1, guri2) -> {
        if (guri1 == null) {
            return -1;
        }
        if (guri2 == null) {
            return 1;
        }
        return guri1.getPath().compareTo(guri2.getPath());
    };

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewGroupCheck(req.getGroup()));
        }
        return new ViewGroupCheck(req.getGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        block12: {
            Database db = req.getDatabase();
            URI uri = req.getURI();
            String relationship = req.getParameter((Parameter)StandardParameters.relationship, "descendants");
            String path = req.getParameter((Parameter)StandardParameters.path);
            long id = req.getParameter((Parameter)StandardParameters.id, -1L);
            if (id != -1L) {
                GroupURI guri = DatabaseQuery.getGroupURIById((Database)db, (Long)id);
                if (guri == null) {
                    res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)GroupFolderErrorID.INVALID_ID);
                    return;
                }
                path = GroupURIs.truncatePath((String)guri.getPath());
            }
            if (path == null && uri != null && uri.isFolder()) {
                path = uri.getPath();
            }
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("groupfolders");
            out.startCollection("groupfolders", OutputPrinter.CollectionOption.JSON_ONLY);
            try {
                if (path == null) break block12;
                boolean sharing = req.getParameter((Parameter)StandardParameters.sharing, true);
                Group group = req.getGroup();
                Member member = req.getMember() == null ? req.getAuthenticatedMember() : req.getMember();
                GroupURI dguri = GroupURIRule.getDefaultGroupURI((Group)group);
                ArrayList<GroupURI> guris = new ArrayList<GroupURI>(DatabaseQuery.getGroupURIsBySchemeHostPortSuperSubpathCol((Database)db, (String)dguri.getScheme(), (String)dguri.getHost().getName(), (Integer)dguri.getPort(), (String)path, (boolean)"descendants".equals(relationship), (boolean)true));
                guris.sort(PATH_ALPHABETICAL_ORDER);
                UserDetails userdetails = null;
                if (member != null && sharing) {
                    userdetails = new UserDetailsManager().get(db, member.getId());
                }
                for (GroupURI guri : guris) {
                    Boolean shared = null;
                    if (!guri.isExternal()) {
                        try {
                            shared = GroupURIRule.isShared((Database)db, (GroupURI)guri) && !guri.getGroupURIForGroupsCol().isEmpty();
                        }
                        catch (QueryFailedException ex) {
                            LOGGER.error("Failed to load shared groups for GroupURI {}", (Object)guri.getId(), (Object)ex);
                        }
                    }
                    if (GroupURIRule.isGeneralGroupURI((GroupURI)guri, (Group)group) || guri.getPath().endsWith("%") || shared != null && !shared.booleanValue() && !GroupURIRule.isDefaultGroupURI((GroupURI)guri, (Group)group)) continue;
                    if (userdetails != null) {
                        out.writeGroupFolder(guri, false, shared);
                        out.writeGroupFolderSharingDetails(guri, userdetails, db);
                        out.endObject();
                        continue;
                    }
                    out.writeGroupFolder(guri, true, shared);
                }
            }
            finally {
                out.endCollection();
                out.endObject();
                out.flush();
            }
        }
    }
}

