/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.groupfolder;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.groupfolder.GroupFolderErrorID;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

@Requires(database=true, member=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetGroupFolder
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        long id = req.getParameter((Parameter)StandardParameters.id, -1L);
        GroupURI guri = null;
        if (id > 0L) {
            guri = DatabaseQuery.getGroupURIById((Database)req.getDatabase(), (Long)id);
        }
        if (guri == null) {
            return new NoCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(guri));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        GroupURI guri;
        boolean sharing = req.getParameter((Parameter)StandardParameters.sharing, true);
        Database db = req.getDatabase();
        Group group = req.getGroup();
        Member member = req.getMember();
        assert (group != null && member != null);
        long id = req.getParameter((Parameter)StandardParameters.id, -1L);
        Object pathString = req.getParameter((Parameter)StandardParameters.path);
        if (id > 0L) {
            guri = DatabaseQuery.getGroupURIById((Database)db, (Long)id);
        } else {
            URL url;
            if (pathString == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "One parameter of id or path is required");
                return;
            }
            GroupURI dguri = GroupURIRule.getDefaultGroupURI((Group)group);
            if (dguri == null) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)GroupFolderErrorID.DEFAULT_GROUP_FOLDER_MISSING, "There is no default group folder for the group " + group.getName());
                return;
            }
            Host host = dguri.getHost();
            if (((String)(pathString = ((String)pathString).toLowerCase())).endsWith("/")) {
                pathString = (String)pathString + "*";
            } else if (!((String)pathString).endsWith("/*")) {
                pathString = (String)pathString + "/*";
            }
            try {
                url = RuleUtils.urlEncodeNormalize((String)(dguri.getScheme() + "://" + host.getName() + ":" + dguri.getPort() + (String)pathString));
            }
            catch (MalformedURLException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.INVALID_PATH, "Invalid path " + (String)pathString + ": " + ex.getMessage());
                return;
            }
            guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)req.getDatabase(), (String)url.getProtocol(), (String)url.getHost(), (Integer)url.getPort(), (String)url.getFile());
        }
        if (guri == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)GroupFolderErrorID.GROUP_FOLDER_NOT_FOUND);
            return;
        }
        GroupURIForGroup gurifg = DatabaseQuery.getGroupURIForGroupByGroupURI((Database)db, (GroupURI)guri, (Group)req.getGroup());
        Group owner = GroupURIRule.getDefaultGroup((Database)db, (GroupURI)guri);
        if (!(owner != null && group.getId().equals(owner.getId()) || gurifg != null)) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)GroupFolderErrorID.GROUP_FOLDER_NOT_IN_GROUP);
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        if (sharing) {
            UserDetails userdetails = new UserDetailsManager().get(db, member.getId());
            out.writeGroupFolder(guri, false, db);
            out.writeGroupFolderSharingDetails(guri, userdetails, db);
            out.endObject();
        } else {
            out.writeGroupFolder(guri, true, db);
        }
        out.flush();
    }
}

