/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.groupfolder;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.groupfolder.GroupFolderErrorID;
import com.pageseeder.groupfolder.GroupFolders;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

@Requires(member=true, group=true, database=true, parameters={"path"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateGroupFolder
implements Generator,
SingleCheck {
    private static final String PUBLIC_GROUP = "public";

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ConfigureProjectCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Long memberid;
        URL url;
        Database db = req.getDatabase();
        Group group = req.getGroup();
        assert (group != null);
        Object path = req.getParameter((Parameter)StandardParameters.path);
        String pub = req.getParameter((Parameter)StandardParameters.public_);
        String groups = req.getParameter((Parameter)StandardParameters.groups);
        String editgroups = req.getParameter((Parameter)StandardParameters.editgroups);
        assert (path != null);
        if (GroupRule.isProject((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.INVALID_GROUP, group.getName() + " is a project");
            return;
        }
        GroupURI dguri = GroupURIRule.getDefaultGroupURI((Group)group);
        if (dguri == null) {
            res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)GroupFolderErrorID.DEFAULT_GROUP_FOLDER_MISSING, "There is no default group folder for the group " + group.getName());
            return;
        }
        Host host = dguri.getHost();
        if (((String)path).endsWith("/")) {
            path = (String)path + "*";
        } else if (!((String)path).endsWith("/*")) {
            path = (String)path + "/*";
        }
        try {
            url = RuleUtils.urlEncodeNormalize((String)(dguri.getScheme() + "://" + host.getName() + ":" + dguri.getPort() + (String)path));
        }
        catch (MalformedURLException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.INVALID_PATH, "Invalid path " + (String)path + ": " + ex.getMessage());
            return;
        }
        if (!url.getFile().startsWith(dguri.getPath().substring(0, dguri.getPath().length() - 1))) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.PATH_NOT_IN_GROUP, "Group folder path " + url.getFile() + " not in group " + group.getName());
            return;
        }
        GroupURI shared = GroupURIRule.getSharedAncestorOrDescendant((String)url.getProtocol(), (String)url.getHost(), (Integer)url.getPort(), (String)path, (boolean)false, (Database)db);
        if (shared != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.ANCESTOR_SHARED_GROUP_FOLDER, "Cannot create group folder path " + url.getFile() + " in shared ancestor " + shared.getPath());
            return;
        }
        shared = GroupURIRule.getSharedAncestorOrDescendant((String)url.getProtocol(), (String)url.getHost(), (Integer)url.getPort(), (String)path, (boolean)true, (Database)db);
        if (shared != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.DESCENDANT_SHARED_GROUP_FOLDER, "Cannot create group folder path " + url.getFile() + " with shared descendant " + shared.getPath());
            return;
        }
        GroupURI guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)url.getProtocol(), (String)url.getHost(), (Integer)url.getPort(), (String)url.getFile());
        Member member = req.getMember();
        assert (member != null);
        UserDetailsManager userManager = new UserDetailsManager();
        UserDetails userdetails = userManager.get(db, member.getId());
        Collection currentGroups = guri != null ? guri.getGroupsCol() : null;
        Collection<Group> grpc = GroupFolders.checkGroups(res, db, groups, group, currentGroups, false, memberid = member.getId(), userdetails);
        if (grpc == null) {
            return;
        }
        Collection<Group> editgrpc = GroupFolders.checkGroups(res, db, editgroups, group, currentGroups, false, memberid, userdetails);
        if (editgrpc == null) {
            return;
        }
        if (grpc.isEmpty() && editgrpc.isEmpty() && pub == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.PUBLIC_OR_GROUPS_REQUIRED);
            return;
        }
        if (grpc.removeAll(editgrpc)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.GROUP_IN_GROUPS_AND_EDITGROUPS);
            return;
        }
        if (guri == null) {
            guri = GroupURI.create((Database)db);
            guri.setScheme(url.getProtocol());
            guri.setHost(host);
            guri.setPath(url.getFile());
            guri.setPort(Integer.valueOf(url.getPort()));
            GroupURIRule.updateURIs((Database)db, (GroupURI)guri);
            guri = guri.insert(db);
        }
        for (Group grp : grpc) {
            GroupURIRule.addGroupURIToGroup((Group)grp, (GroupURI)guri, (boolean)false, (Database)db);
        }
        for (Group grp : editgrpc) {
            GroupURIRule.addGroupURIToGroup((Group)grp, (GroupURI)guri, (boolean)true, (Database)db);
        }
        Collection folderUris = GroupURIRule.checkForFolderURIs((GroupURI)guri, (Member)member, (Database)db);
        if (pub != null) {
            Group publicGroup = DatabaseQuery.getGroupByName((Database)db, (String)PUBLIC_GROUP);
            assert (publicGroup != null);
            boolean currentPub = GroupURIRule.belongsToGroup((GroupURI)guri, (String)PUBLIC_GROUP);
            if ("true".equals(pub) && !currentPub) {
                GroupURIRule.addGroupURIToGroup((Group)publicGroup, (GroupURI)guri, (boolean)false, (Database)db);
            } else if ("false".equals(pub) && currentPub) {
                publicGroup.removeGroupURIs(guri);
            }
        }
        req.getTransaction().commitAndStart();
        ChangesManager changes = ChangesManager.getInstance();
        ArrayList<Group> addedGroups = new ArrayList<Group>();
        addedGroups.addAll(editgrpc);
        addedGroups.addAll(grpc);
        ArrayList<Group> allgroups = new ArrayList<Group>();
        allgroups.addAll(addedGroups);
        allgroups.add(group);
        changes.createGroupfolder(db, guri, allgroups);
        if (!folderUris.isEmpty() || !addedGroups.isEmpty()) {
            ChangesBatch batch = new ChangesBatch("Sharing group folder " + guri.getPath());
            changes.startBatch(db, batch);
            for (URI uri : folderUris) {
                changes.createURI(db, batch, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
            }
            if (!addedGroups.isEmpty()) {
                Collection uris = DatabaseQuery.getURIsByGroupURI((Database)db, (GroupURI)guri);
                for (URI uri : uris) {
                    if (folderUris.contains(uri)) continue;
                    changes.createURI(db, batch, uri, addedGroups);
                }
            }
            changes.completeBatch(db, batch);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("groupfolder-creation");
        out.writeGroupFolder(guri, false, db);
        out.writeGroupFolderSharingDetails(guri, userdetails, db);
        out.endObject();
        out.endObject();
        out.flush();
    }
}

