/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.CreateProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

@Requires(database=true, member=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class ListProjects
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 1000L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if ("server".equals(req.getParameter((Parameter)StandardParameters.for_))) {
            return new CreateProjectCheck(req.getHttpServletRequest());
        }
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        List<Group> groups;
        String nameprefix;
        Database db = req.getDatabase();
        Member m = req.getMember();
        assert (m != null);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        boolean includeGroups = req.getParameter((Parameter)StandardParameters.groups, true);
        boolean server = "server".equals(req.getParameter((Parameter)StandardParameters.for_));
        boolean archived = req.getParameter((Parameter)StandardParameters.archived, false);
        boolean allProjects = req.getParameter((Parameter)StandardParameters.allprojects, false);
        boolean children = "children".equals(req.getParameter((Parameter)StandardParameters.relationship, "children"));
        Group context = allProjects ? null : req.getGroup();
        String string = nameprefix = context == null ? null : context.getName() + "-";
        if (server) {
            groups = DatabaseQuery.getGroupsByNameprefix((Database)db, (int)page, (int)pagesize, (String)nameprefix, (boolean)archived, (!children ? 1 : 0) != 0, (boolean)includeGroups, (boolean)true);
        } else {
            groups = new ArrayList();
            List groupnames = MemberRule.getGroupnames((UserDetails)new UserDetailsManager().get(db, m.getId(), archived));
            if (groupnames.size() > pagesize) {
                Collections.sort(groupnames);
            }
            int i = 0;
            int start = pagesize * (page - 1);
            int end = pagesize * page + 1;
            for (String groupname : groupnames) {
                Group group;
                if (!ListProjects.isGroupVisible(groupname, nameprefix, children) || (group = DatabaseQuery.getGroupByName((Database)db, (String)groupname)) == null || archived != GroupRule.isArchived((Group)group) || !includeGroups && !GroupRule.isProject((Group)group)) continue;
                if (i >= start && i < end) {
                    groups.add(group);
                }
                ++i;
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("projects");
        if (!server) {
            out.field("for", m.getUsername());
        }
        if (groups.size() > pagesize) {
            out.field("limitreached", true);
        }
        int nb = 0;
        out.startCollection("projects", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Group g : groups) {
            if (nb < pagesize) {
                out.writeGroup(g, true, false, false);
            }
            ++nb;
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private static boolean isGroupVisible(String name, @Nullable String prefix, boolean children) {
        return !"admin".equals(name) && !"public".equals(name) && (prefix == null && (name.indexOf(45) == -1 || !children) || prefix != null && name.startsWith(prefix) && (name.substring(prefix.length()).indexOf(45) == -1 || !children));
    }
}

