/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewOrEditGroupCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.group.GroupErrorID;
import java.io.IOException;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class GetGroup
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        String nameOrId = req.getParameter((Parameter)StandardParameters.group);
        Group group = req.getGroup();
        if (nameOrId != null) {
            try {
                group = GroupRule.getGroup((Database)req.getDatabase(), (String)nameOrId);
            }
            catch (QueryFailedException e) {
                return new NoCheck();
            }
        }
        return new ViewOrEditGroupCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String nameOrId = req.getParameter((Parameter)StandardParameters.group);
        Group group = req.getGroup();
        if (nameOrId != null) {
            try {
                group = GroupRule.getGroup((Database)req.getDatabase(), (String)nameOrId);
            }
            catch (QueryFailedException e) {
                group = null;
            }
        }
        if (group == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)GroupErrorID.INVALID_GROUP_PARAMETER, "Failed to load group with ID " + nameOrId);
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.writeGroup(group, true, true, false, req.getDatabase());
        out.flush();
    }
}

