/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupMediator;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.group.GroupErrorID;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@Requires(member=true, group=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class EditGroup
implements Generator,
SingleCheck {
    @ContentPermission(value=EditGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new EditGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String description = req.getParameter((Parameter)StandardParameters.description);
        String title = req.getParameter((Parameter)StandardParameters.title);
        String owner = req.getParameter((Parameter)StandardParameters.owner);
        String visibility = req.getParameter((Parameter)StandardParameters.visibility);
        String template = req.getParameter((Parameter)StandardParameters.template);
        String detailstype = req.getParameter((Parameter)StandardParameters.detailstype);
        String relatedurl = req.getParameter((Parameter)StandardParameters.relatedurl);
        String message = req.getParameter((Parameter)StandardParameters.message);
        String access = req.getParameter((Parameter)StandardParameters.access);
        String commenting = req.getParameter((Parameter)StandardParameters.commenting);
        String moderation = req.getParameter((Parameter)StandardParameters.moderation);
        String registration = req.getParameter((Parameter)StandardParameters.registration);
        String defaultrole = req.getParameter((Parameter)StandardParameters.defaultrole);
        String defaultnotify = req.getParameter((Parameter)StandardParameters.defaultnotify);
        String common = req.getParameter((Parameter)StandardParameters.common);
        String editurls = req.getParameter((Parameter)StandardParameters.editurls);
        Database db = req.getDatabase();
        Group group = req.getGroup();
        assert (group != null);
        Member authMember = req.getAuthenticatedMember();
        assert (authMember != null);
        UserDetails userdetails = new UserDetailsManager().get(db, authMember.getId());
        boolean admin = MemberRule.isAdministrator((Map)userdetails.flags());
        Group templateProj = GroupRule.getTemplateProject((Database)db, (Group)group);
        boolean projectManager = templateProj != null && GroupRule.isProject((Group)templateProj) && MemberRule.isProjectManager((String)templateProj.getName(), (Map)userdetails.flags());
        boolean templateChanged = false;
        try {
            GroupMediator mediator = new GroupMediator(db);
            if (description != null) {
                mediator.setDescription(description);
            }
            if (title != null) {
                mediator.setTitle(title);
            }
            if (owner != null) {
                mediator.setOwner(owner);
            }
            if (visibility != null) {
                mediator.setVisibility(visibility);
            }
            if (template != null && !template.equals(group.getOwnerDirectory())) {
                mediator.setTemplate(template);
                templateChanged = true;
            }
            if (detailstype != null) {
                mediator.setDetailstype(detailstype);
            }
            if (relatedurl != null) {
                mediator.setRelatedurl(relatedurl);
            }
            if (message != null) {
                mediator.setMessage(message);
            }
            if (access != null) {
                mediator.setAccess(access);
            }
            if (commenting != null) {
                mediator.setCommenting(commenting);
            }
            if (moderation != null) {
                mediator.setModeration(moderation);
            }
            if (registration != null) {
                mediator.setRegistration(registration);
            }
            if (defaultrole != null) {
                mediator.setDefaultrole(defaultrole);
            }
            if (defaultnotify != null) {
                mediator.setDefaultnotify(defaultnotify);
            }
            if (common != null) {
                mediator.setCommon(Boolean.valueOf(common));
            }
            if (editurls != null) {
                mediator.setEditURLs(Boolean.valueOf(editurls));
            }
            boolean editProperties = this.handleProperties(req, group, mediator, db);
            boolean modified = mediator.edit(group, admin, projectManager, editProperties);
            req.getTransaction().commit();
            if (templateChanged && !GroupRule.isProject((Group)group)) {
                IndexMaster.getInstance().updateIndex(group, db);
            }
            if (modified) {
                if (GroupRule.isProject((Group)group)) {
                    ChangesManager.getInstance().modifyProject(db, group);
                } else {
                    ChangesManager.getInstance().modifyGroup(db, group);
                }
            }
            if (editProperties) {
                ChangesManager.getInstance().modifyGroupProperties(db, group);
            }
            new MembershipCache().removeAll();
        }
        catch (FoundationException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_GROUP_SETTING_PARAMETER, ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject(GroupRule.isProject((Group)group) ? "project-modification" : "group-modification");
        out.writeGroup(group, true, true, false, db);
        out.endObject();
        out.flush();
    }

    private boolean handleProperties(GeneratorRequest req, Group grp, GroupMediator mediator, Database db) throws IOException, QueryFailedException {
        Properties currentProps = GroupProperties.getOverwritten((Database)db, (Group)grp);
        boolean updateProperties = false;
        Set pnames = req.getParameters().keySet();
        for (String pname : pnames) {
            String currentValue;
            if (!pname.startsWith("property.")) continue;
            String propName = pname.substring(9);
            String propValue = req.getParameter(pname);
            if ("true".equals(req.getParameter("defaultproperty." + pname))) {
                propValue = null;
            }
            if (!Strings.equals((String)(currentValue = currentProps.getProperty(propName)), (String)propValue)) {
                updateProperties = true;
            }
            if (propValue == null) continue;
            mediator.setProperty(propName, propValue);
        }
        Enumeration<Object> epnames = currentProps.keys();
        while (epnames.hasMoreElements()) {
            String pname;
            pname = (String)epnames.nextElement();
            if ("true".equals(req.getParameter("defaultproperty." + pname))) {
                updateProperties = true;
                continue;
            }
            if (req.getParameter("property." + pname) != null) continue;
            mediator.setProperty(pname, currentProps.getProperty(pname));
        }
        return updateProperties;
    }
}

