/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.rule.SubGroupRole;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForGroup;
import com.pageseeder.db.model.Member;
import com.pageseeder.group.GroupErrorID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Requires(group=true, database=true, parameters={"subgroup"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class AddSubgroup
implements Generator,
MultipleCheck {
    private static final String INHERIT = "inherit";

    @ContentPermission(value=EditGroupCheck.class)
    public List<PermissionCheck> getPermissionChecks(GeneratorRequest req) throws DatabaseException {
        ArrayList<PermissionCheck> checks = new ArrayList<PermissionCheck>();
        Group childGroup = GroupRule.getGroup((Database)req.getDatabase(), (String)req.getParameter((Parameter)StandardParameters.subgroup));
        if (childGroup == null) {
            checks.add((PermissionCheck)new NoCheck());
        } else {
            checks.add((PermissionCheck)new EditGroupCheck(req.getGroup()));
            checks.add((PermissionCheck)new EditGroupCheck(childGroup));
        }
        return checks;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Notification notification;
        SubGroupRole role;
        Group group = req.getGroup();
        assert (group != null);
        String childGroupNameOrID = req.getParameter((Parameter)StandardParameters.subgroup);
        String roleParam = req.getParameter((Parameter)StandardParameters.role, INHERIT);
        String notificationParam = req.getParameter((Parameter)StandardParameters.notification, INHERIT);
        String listedParam = req.getParameter((Parameter)StandardParameters.listed, INHERIT);
        Database db = req.getDatabase();
        Group childGroup = GroupRule.getGroup((Database)db, (String)childGroupNameOrID);
        if (childGroup == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_GROUP_PARAMETER);
            return;
        }
        if (childGroup.getId().equals(group.getId())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_GROUP_PARAMETER, "A group cannot be a subgroup of itself.");
            return;
        }
        GroupForGroup existing = DatabaseQuery.getGroupForGroupByMainGroupSubGroup((Database)db, (Long)group.getId(), (Long)childGroup.getId());
        if (existing != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.SUBGROUP_ALREADY_EXISTS);
            return;
        }
        if (INHERIT.equals(roleParam)) {
            role = null;
        } else {
            role = SubGroupRole.forAttribute((String)roleParam);
            if (role == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_ROLE_PARAMETER);
                return;
            }
        }
        if (INHERIT.equals(notificationParam)) {
            notification = null;
        } else {
            notification = Notification.forType((String)notificationParam);
            if (notification == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_NOTIFICATION_PARAMETER);
                return;
            }
        }
        Boolean listed = INHERIT.equals(listedParam) ? null : Boolean.valueOf(Boolean.parseBoolean(listedParam));
        GroupForGroup subgroup = GroupForGroup.create((Database)db);
        subgroup.setGroup(group);
        subgroup.setMemberGroup(childGroup);
        subgroup.setListed(listed);
        if (notification != null) {
            subgroup.setNotification(notification.type().toLowerCase());
        }
        if (role != null) {
            subgroup.setRoleFlags(role.groupForGroupFlags());
        }
        subgroup.insert(db);
        group.addGroupForGroup(subgroup);
        Collection members = DatabaseQuery.getMembersByGroupIdNoSubgroups((Database)db, (Long)childGroup.getId());
        UserDetailsManager detailsManager = new UserDetailsManager();
        for (Member mem : members) {
            detailsManager.remove(mem.getId());
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("subgroup-addition");
        out.writeSubgroup(subgroup);
        out.endObject();
        out.flush();
    }
}

