/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.export;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class URIPathPatternFilter {
    private final List<String> excludePatterns = new ArrayList<String>();
    private final List<String> includePatterns = new ArrayList<String>();
    private final String rootPath;

    public URIPathPatternFilter(String rootpath) {
        this.rootPath = rootpath;
    }

    public void addExcludePatterns(String @Nullable [] patterns) {
        if (patterns == null) {
            return;
        }
        for (String exc : patterns) {
            if (exc.isEmpty()) continue;
            this.excludePatterns.add(this.createRegex(exc));
            if (exc.indexOf(42) != -1) continue;
            this.excludePatterns.add(this.createRegex(exc + "/**"));
        }
    }

    public boolean isExcluded(@Nullable String path) {
        if (path == null) {
            return false;
        }
        for (String exc : this.excludePatterns) {
            if (!path.matches(exc)) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluded(@Nullable String path) {
        if (path == null) {
            return false;
        }
        if (this.includePatterns.isEmpty()) {
            return true;
        }
        for (String inc : this.includePatterns) {
            if (!path.matches(inc)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPatterns() {
        return !this.includePatterns.isEmpty() || !this.excludePatterns.isEmpty();
    }

    public void addIncludePatterns(String @Nullable [] patterns) {
        if (patterns == null) {
            return;
        }
        for (String inc : patterns) {
            if (inc.isEmpty()) continue;
            this.includePatterns.add(this.createRegex(inc));
            if (inc.indexOf(42) != -1) continue;
            this.excludePatterns.add(this.createRegex(inc + "/**"));
        }
    }

    private String createRegex(String pattern) {
        return "^" + (this.rootPath + "/" + pattern).replaceAll("[.()\\[\\]^$+]", "\\\\$0").replaceAll("\\?", ".").replaceAll("\\*\\*", "[psdoublestar]").replaceAll("\\*", "([^/]*?)").replaceAll("\\[psdoublestar]", "(.*?)") + "$";
    }
}

