/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer.config;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.model.Group;
import com.pageseeder.developer.config.Bundle;
import com.pageseeder.developer.config.Bundles;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true, parameters={"type"})
public final class ListBundles
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ConfigureProjectCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        assert (group != null);
        XMLWriter xml = res.getXMLWriter();
        boolean def = "true".equals(req.getParameter((Parameter)StandardParameters.default_));
        String template = def ? "default" : GroupRule.getTemplate((Group)group);
        boolean loadAll = req.getParameter((Parameter)StandardParameters.loadall, false);
        if (template != null) {
            ArrayList<Template> kits = new ArrayList<Template>();
            kits.add(new Template(template));
            if (loadAll) {
                String globalTemplate = GlobalSettings.getGlobalTemplate();
                if (globalTemplate != null && !globalTemplate.equals(template)) {
                    kits.add(new Template(globalTemplate));
                }
                kits.add(new Template("default"));
            }
            File webapp = new File(Settings.getContextPath());
            String types = req.getParameter((Parameter)StandardParameters.type, "");
            xml.openElement("bundles");
            for (String type : types.split(",")) {
                ArrayList<String> names = new ArrayList<String>();
                for (Template kit : kits) {
                    for (String name : Bundles.list(kit, webapp, type)) {
                        if (names.contains(name)) continue;
                        names.add(name);
                    }
                }
                for (String name : names) {
                    Bundle b = Bundles.getInstance(type, name);
                    if (b == null) continue;
                    for (Template kit : kits) {
                        if (!Bundles.list(kit, webapp, type).contains(name)) continue;
                        b.load(kit, webapp);
                    }
                    b.toXML(xml);
                }
            }
            xml.closeElement();
            xml.flush();
        }
    }
}

