/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.thread.ProcessMetadataThread;
import java.io.IOException;

@Requires(database=true, group=true, member=true, parameters={"extension"})
public final class ProcessMetadata
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditGroupCheck(req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        Member member = req.getMember();
        assert (group != null && member != null);
        String extension = req.getParameter((Parameter)StandardParameters.extension);
        String documentType = req.getParameter((Parameter)StandardParameters.document_type);
        boolean overwrite = "true".equals(req.getParameter((Parameter)StandardParameters.overwrite, "false"));
        assert (extension != null);
        if (GroupRule.isProject((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Metadata can only be processed from a group (not a project).");
            return;
        }
        if (extension.equalsIgnoreCase("psml")) {
            if (documentType == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "The psml extension requires document-type.");
                return;
            }
        } else if (documentType != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The document-type is only for the psml extension.");
            return;
        }
        ProcessMetadataThread thread = new ProcessMetadataThread(member.getUsername(), group, extension, overwrite, documentType);
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("metadata-process");
        out.write((UniversallyPrintable)thread);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

