/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplatePacker;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Group;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ImportProjectFiles
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        String owner = GroupRule.getTemplate((Group)group);
        Template template = TemplateFactory.forLocation((String)req.getParameter((Parameter)StandardParameters.pack));
        if (template == null || template.isDefault() || !template.name().equals(owner)) {
            return new ForbiddenCheck();
        }
        return new DevelopCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        UniversalPrinter out;
        Template template;
        block8: {
            File webapp = new File(Settings.getContextPath());
            String location = req.getParameter((Parameter)StandardParameters.pack);
            template = TemplateFactory.forLocation((String)location);
            if (template == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Not a valid location.");
                return;
            }
            File pack = new File(webapp, location);
            boolean isValid = TemplatePacker.isTemplatePack((File)pack);
            if (!isValid) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Not a valid template pack.");
                return;
            }
            out = res.getUniversalWriter();
            out.startObject("import");
            out.field("project", template.name());
            out.field("datetime", ISO8601.format((long)System.currentTimeMillis(), (ISO8601)ISO8601.DATETIME));
            out.field("file", pack.getName());
            try {
                TemplatePacker packer = new TemplatePacker(webapp);
                if (req.getParameter("check-only", false)) {
                    TemplatePacker.PackCheck check = packer.checkUnpack(template, pack);
                    out.field("check", true);
                    out.field("from-pageseeder", check.isPageseeder());
                    out.startCollection("files", OutputPrinter.CollectionOption.JSON_ONLY);
                    for (File f : check.getFiles()) {
                        out.writeFile(f, 0, false);
                    }
                    out.endCollection();
                    break block8;
                }
                packer.unpack(template, pack);
            }
            catch (ZipException ex) {
                try {
                    res.setError(GeneratorStatus.BAD_REQUEST, "Not a valid template pack.");
                }
                catch (Throwable throwable) {
                    SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.CONFIGURATION_CHANGE, (String)"Imported template files into {}", (Object[])new Object[]{template.name()});
                    out.endObject();
                    throw throwable;
                }
                SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.CONFIGURATION_CHANGE, (String)"Imported template files into {}", (Object[])new Object[]{template.name()});
                out.endObject();
            }
        }
        SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.CONFIGURATION_CHANGE, (String)"Imported template files into {}", (Object[])new Object[]{template.name()});
        out.endObject();
        out.flush();
    }
}

