/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Group;
import com.pageseeder.developer.DevUtils;
import com.pageseeder.developer.DeveloperZone;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true)
public final class GetProjectFiles
implements Generator,
SingleCheck {
    private volatile File webapp = null;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        String location = req.getParameter((Parameter)StandardParameters.location);
        if (group != null && ("schema".equals(location) || "member".equals(location))) {
            return new ConfigureProjectCheck(group);
        }
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        assert (group != null);
        if (this.webapp == null) {
            this.webapp = new File(Settings.getContextPath());
        }
        XMLWriter xml = res.getXMLWriter();
        String template = GroupRule.getTemplate((Group)group);
        if (template != null) {
            List<TemplateZone> zones = GetProjectFiles.toZones(req);
            String location = req.getParameter((Parameter)StandardParameters.location);
            this.toXML(xml, new Template(template), zones, location);
        } else {
            xml.emptyElement("no-style-owner");
        }
        xml.flush();
    }

    private void toXML(XMLWriter xml, Template template, List<TemplateZone> zones, @Nullable String location) throws IOException {
        TemplateFiles resources = new TemplateFiles(template, this.webapp);
        for (TemplateZone zone : zones) {
            File root = new File(this.webapp, zone.folder(template));
            if (location != null) {
                root = new File(root, location);
            }
            this.toXML(root, xml, resources);
        }
    }

    public void toXML(File f, XMLWriter xml, TemplateFiles resources) throws IOException {
        String location = "/" + Files.path((File)this.webapp, (File)f);
        xml.openElement("file");
        xml.attribute("name", f.getName());
        xml.attribute("path", location);
        if (f.exists()) {
            if (f.isDirectory()) {
                xml.attribute("type", "folder");
                for (File x : f.listFiles(DevUtils.READABLE_AND_VISIBLE)) {
                    this.toXML(x, xml, resources);
                }
            } else {
                String type = Medias.getMediaType((File)f);
                boolean isText = Medias.isText((String)type);
                boolean overrides = resources.overridesDefault(location);
                xml.attribute("type", "file");
                if (type != null) {
                    xml.attribute("mediatype", type);
                }
                xml.attribute("length", Long.toString(f.length()));
                xml.attribute("modified", ISO8601.DATETIME.format(f.lastModified()));
                xml.attribute("text", Boolean.toString(isText));
                xml.attribute("overrides", Boolean.toString(overrides));
            }
        } else {
            xml.attribute("status", "not-found");
        }
        xml.closeElement();
    }

    private static List<TemplateZone> toZones(GeneratorRequest req) {
        String[] p;
        ArrayList<TemplateZone> zones = new ArrayList<TemplateZone>();
        for (String z : p = Strings.split((String)req.getParameter((Parameter)StandardParameters.zones, "template"), (char)',')) {
            if ("template".equalsIgnoreCase(z)) {
                zones.add((TemplateZone)TemplateFiles.Zone.TEMPLATE);
            }
            if ("dropbox".equalsIgnoreCase(z)) {
                zones.add(DeveloperZone.DROPBOX);
            }
            if (!"export".equalsIgnoreCase(z)) continue;
            zones.add(DeveloperZone.EXPORT);
        }
        return zones;
    }
}

