/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateHistory;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.model.Group;
import java.io.File;
import java.io.IOException;
import java.util.List;

@Requires(database=true, group=true, parameters={"location"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetProjectFileHistory
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        String template = GroupRule.getTemplate((Group)group);
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        Template kit = TemplateFactory.forLocation((String)req.getParameter((Parameter)StandardParameters.location));
        if (kit == null) {
            return new ForbiddenCheck();
        }
        if (!(kit.isDefault() || kit.name().equals(template) || kit.name().equals(globalTemplate))) {
            return new ForbiddenCheck();
        }
        return new ConfigureProjectCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        assert (group != null);
        UniversalPrinter out = res.getUniversalWriter();
        String owner = GroupRule.getTemplate((Group)group);
        if (owner != null) {
            String location = req.getParameter((Parameter)StandardParameters.location);
            assert (location != null);
            Template template = TemplateFactory.forLocation((String)location);
            File webapp = new File(Settings.getContextPath());
            TemplateHistory history = new TemplateHistory(template, webapp);
            List files = history.getHistory(location);
            out.startObject("history");
            out.startCollection("history", OutputPrinter.CollectionOption.JSON_ONLY);
            for (File f : files) {
                out.writeFile(f, 0, false);
            }
            out.endCollection();
            out.endObject();
        } else {
            out.startObject("no-style-owner");
            out.endObject();
        }
        out.flush();
    }
}

