/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.content;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.GeneralLogTracker;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.pageseeder.xmlwriter.XMLWriter;

public final class TrackDateGeneralLog
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String datetime = req.getParameter((Parameter)StandardParameters.datetime);
        try {
            Date date;
            if (datetime == null) {
                String dateParam = req.getParameter((Parameter)StandardParameters.date);
                String timeParam = req.getParameter((Parameter)StandardParameters.time);
                int offsetInMillis = TimeZone.getDefault().getOffset(ISO8601.CALENDAR_DATE.parse(dateParam).getTime());
                String offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
                date = ISO8601.parseAuto((String)(dateParam + "T" + timeParam + "00:00:00".substring(Math.min(timeParam.length(), 8)) + (offsetInMillis >= 0 ? "+" : "-") + offset));
            } else {
                date = ISO8601.parseAuto((String)datetime);
            }
            GeneralLogTracker tracker = new GeneralLogTracker();
            tracker.setDate(date);
            tracker.build();
            XMLWriter xml = res.getXMLWriter();
            tracker.toXML(xml);
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Not a valid ISO8601 date");
        }
        catch (NumberFormatException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Not a valid page number");
        }
    }
}

