/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditXLinkCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.state.GroupStateManager;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSRequester;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

@Requires(member=true, parameters={"xlink"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class UnarchiveComment
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Database db = req.getDatabase();
        XLink xlink = DatabaseQuery.getXLinkById((Database)db, (Long)req.getParameter((Parameter)StandardParameters.xlink, -1L));
        if (xlink == null) {
            return new NoCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditXLinkCheck(URIRule.getURIByXLink((XLink)xlink), xlink));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        XLink threadRoot;
        Database db = req.getDatabase();
        XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)req.getParameter((Parameter)StandardParameters.xlink, -1L));
        if (xl == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)CommentErrorID.COMMENT_NOT_FOUND);
            return;
        }
        if (!XLinks.isArchived((XLink)xl)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.COMMENT_NOT_ARCHIVED);
            return;
        }
        if (!XLinks.isComment((XLink)xl)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.NOT_A_COMMENT);
            return;
        }
        URI uri = URIRule.getURIByXLink((XLink)xl);
        XLinkRule.unarchiveXLink((XLink)xl);
        Date modified = new Date();
        xl.setModifiedBy(req.getMember());
        xl.setModifiedDate(modified);
        if (XLinks.isComment((XLink)xl) && xl.getAccepted().booleanValue() && !xl.equals((Object)(threadRoot = XLinks.getThreadRoot((XLink)xl)))) {
            XLinkRule.updateThreadEnd((XLink)threadRoot);
        }
        Collection groups = XLinkRule.getGroups((XLink)xl);
        for (Group grp : groups) {
            GroupStateManager.singleton().setCommentsModified(grp, modified);
        }
        req.getTransaction().commitAndStart();
        ChangesManager.getInstance().unarchiveComment(db, xl, groups);
        if (URIs.canBeIndexedAsURL((URI)uri)) {
            IndexMaster.getInstance().indexURL(uri.getId(), false, null, new PSRequester("Unarchiving comment " + xl.getId()));
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("comment-unarchive");
        if (!xl.getAccepted().booleanValue()) {
            out.field("moderated", true);
        }
        out.writeComment(xl);
        out.endObject();
        out.flush();
    }
}

