/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.comment.Comments;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.XLink;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.XML, OutputType.JSON})
public final class GetTasksByFilter
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 1000L;
    private static final long DEFAULT_TASK_SIZE = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GetTasksByFilter.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        NoCheck check = new NoCheck();
        if ("all".equals(req.getParameter((Parameter)StandardParameters.emails))) {
            check = new ManageAccountCheck();
        }
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
        }
        return check;
    }

    /*
     * WARNING - void declaration
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        void var38_45;
        Publication publication;
        Collection<Object> groupnames;
        String groups = req.getNonEmptyParameter((Parameter)StandardParameters.groups);
        String project = req.getNonEmptyParameter((Parameter)StandardParameters.project);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int taskSize = (int)req.getParameter((Parameter)StandardParameters.tasksize, 100L);
        String comments = req.getParameter((Parameter)StandardParameters.comments, "last");
        String contents = req.getParameter((Parameter)StandardParameters.contents, "all");
        String attachments = req.getParameter((Parameter)StandardParameters.attachments, "all");
        String emails = req.getParameter((Parameter)StandardParameters.emails, "none");
        String context = req.getParameter((Parameter)StandardParameters.context, "all");
        String paths = req.getNonEmptyParameter((Parameter)StandardParameters.paths);
        String title = req.getNonEmptyParameter((Parameter)StandardParameters.title);
        String type = req.getNonEmptyParameter((Parameter)StandardParameters.type);
        String types = req.getParameter((Parameter)StandardParameters.types);
        Long author = req.getParameter((Parameter)StandardParameters.author, -1L);
        Long assignedto = req.getParameter((Parameter)StandardParameters.assignedto, -1L);
        String createdafter = req.getNonEmptyParameter((Parameter)StandardParameters.createdafter);
        String createdbefore = req.getNonEmptyParameter((Parameter)StandardParameters.createdbefore);
        String modifiedafter = req.getNonEmptyParameter((Parameter)StandardParameters.modifiedafter);
        String assignedafter = req.getNonEmptyParameter((Parameter)StandardParameters.assignedafter);
        String assignedbefore = req.getNonEmptyParameter((Parameter)StandardParameters.assignedbefore);
        String dueafter = req.getNonEmptyParameter((Parameter)StandardParameters.dueafter);
        String duebefore = req.getNonEmptyParameter((Parameter)StandardParameters.duebefore);
        String labels = req.getNonEmptyParameter((Parameter)StandardParameters.labels);
        String statuses = req.getNonEmptyParameter((Parameter)StandardParameters.statuses);
        String priorities = req.getNonEmptyParameter((Parameter)StandardParameters.priorities);
        String contentrole = req.getParameter((Parameter)StandardParameters.contentrole, "all");
        String pubid = req.getParameter((Parameter)StandardParameters.publicationid, "");
        if (!Comments.checkLabels(res, labels)) {
            return;
        }
        Database db = req.getDatabase();
        UserDetails userdetails = req.getMember() != null ? new UserDetailsManager().get(db, req.getMember().getId(), false) : SecurityUtils.getDefaultUserDetails();
        ArrayList usergroups = new ArrayList(userdetails.flags().keySet());
        usergroups.remove("admin");
        Collection<Object> collection = groupnames = groups == null ? usergroups : Arrays.asList(groups.split(","));
        if (project != null) {
            groupnames = GroupRule.removeNonProjectGroupNames(groupnames, (String)project);
        }
        ArrayList<String> grps = new ArrayList<String>();
        ArrayList<Group> grpc = new ArrayList<Group>();
        for (String string : groupnames) {
            Group grp = DatabaseQuery.getGroupByName((Database)db, (String)string);
            if (grp == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Invalid group name: " + string);
                return;
            }
            if (groups == null) {
                if (grp.hasFlag('d')) {
                    continue;
                }
            } else if (!GroupRule.userHasAccess((Group)grp, (UserDetails)userdetails)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Not allowed to access group: " + string);
                return;
            }
            grps.add(grp.getName());
            grpc.add(grp);
        }
        XLink pubXlink = null;
        if (!pubid.isEmpty() && !grpc.isEmpty() && (publication = Publications.getPublicationByPublicationIDGroup((Database)db, (String)pubid, (Group)((Group)grpc.get(0)))) != null) {
            pubXlink = DatabaseQuery.getXLinkById((Database)db, (Long)publication.getXLinkId());
        }
        Object var38_41 = null;
        List<String> statusesList = null;
        List<String> labelsList = null;
        List<String> prioritiesList = null;
        List<String> typesList = null;
        if (paths != null) {
            List<String> list = Arrays.asList(paths.split(","));
        }
        if ("group".equals(context)) {
            if (paths != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTEXT_AMBIGUOUS, "Context 'group' cannot be used with 'paths' parameter");
                return;
            }
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            for (Group g : grpc) {
                arrayList.add((CallSite)((Object)(GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/" + g.getId())));
            }
        }
        if (types != null) {
            typesList = Arrays.asList(types.split(","));
        }
        if (statuses != null) {
            statusesList = Arrays.asList(statuses.split(","));
        }
        if (priorities != null) {
            prioritiesList = Arrays.asList(priorities.split(","));
        }
        if (labels != null) {
            labelsList = Arrays.asList(labels.split(","));
        }
        Member authormem = null;
        if (!author.equals(-1L) && (authormem = this.loadMember(author, "author", db, res)) == null) {
            return;
        }
        if (assignedto.compareTo(0L) < 0) {
            assignedto = null;
        }
        Date createdAfterDate = null;
        Date createdBeforeDate = null;
        Date modifiedAfterDate = null;
        Date assignedBeforeDate = null;
        Date assignedAfterDate = null;
        Date dueFromDate = null;
        Date dueToDate = null;
        if (createdafter != null && (createdAfterDate = this.loadDate(createdafter, "createdafter", res)) == null) {
            return;
        }
        if (createdbefore != null && (createdBeforeDate = this.loadDate(createdbefore, "createdbefore", res)) == null) {
            return;
        }
        if (modifiedafter != null && (modifiedAfterDate = this.loadDate(modifiedafter, "modifiedafter", res)) == null) {
            return;
        }
        if (assignedafter != null && (assignedAfterDate = this.loadDate(assignedafter, "assignedafter", res)) == null) {
            return;
        }
        if (assignedbefore != null && (assignedBeforeDate = this.loadDate(assignedbefore, "assignedbefore", res)) == null) {
            return;
        }
        if (dueafter != null && (dueFromDate = this.loadDate(dueafter, "duefrom", res)) == null) {
            return;
        }
        if (duebefore != null && (dueToDate = this.loadDate(duebefore, "dueto", res)) == null) {
            return;
        }
        List tasks = DatabaseQuery.getTasksByFilterParams((Database)db, (int)page, (int)pagesize, grpc, (Collection)var38_45, (String)title, (String)type, typesList, (Member)authormem, (Long)assignedto, (Date)createdAfterDate, (Date)createdBeforeDate, (Date)modifiedAfterDate, (Date)dueFromDate, (Date)dueToDate, (Date)assignedAfterDate, (Date)assignedBeforeDate, prioritiesList, statusesList, labelsList, (!"uri".equals(context) ? 1 : 0) != 0, (String)contentrole, (XLink)pubXlink);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("tasks");
        out.startCollection("tasks", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Discussion task : tasks) {
            if ("all".equals(comments)) {
                task.loadAllComments(db, taskSize);
            } else if ("first".equals(comments)) {
                task.loadFirstComment(db);
            } else if ("last".equals(comments)) {
                task.loadLastComment(db, true);
            } else if ("archive".equals(comments)) {
                task.loadArchiveComments(db, taskSize);
            }
            task.loadUri(db, null);
            out.writeDiscussion(task, "task", db, grpc, "all".equals(contents), "all".equals(attachments), "all".equals(emails), null);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private @Nullable Date loadDate(String dateValue, String dateName, GeneratorResponse res) {
        try {
            return ISO8601.DATETIME.parse(dateValue);
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DATE_INVALID, "The " + dateName + " date is invalid: " + dateValue);
            return null;
        }
    }

    private @Nullable Member loadMember(long memID, String memParam, Database db, GeneratorResponse res) {
        Member mem = null;
        try {
            mem = DatabaseQuery.getMemberById((Database)db, (Long)memID);
        }
        catch (QueryFailedException e) {
            LOGGER.error("Failed to load member with id {}", (Object)memID, (Object)e);
        }
        if (mem == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.MEMBER_INVALID, "The " + memParam + " id is not valid: " + memID);
        }
        return mem;
    }
}

