/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.state.GroupStateManager;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.comment.Comments;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

@Requires(group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetDiscussionsForGroup
implements Generator,
SingleCheck,
Cacheable {
    private static final long DEFAULT_MAX_NB = 10L;
    private static final long DEFAULT_DISCUSSION_SIZE = 100L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        ViewGroupCheck check = new ViewGroupCheck(req.getGroup());
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
        }
        return check;
    }

    public String getETag(GeneratorRequest req) throws DatabaseException {
        Date modified = GroupStateManager.singleton().getCommentsModified(req.getDatabase(), req.getGroup());
        return modified != null ? MD5.hash((String)Long.toString(modified.getTime())) : null;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 10L);
        int discussionSize = (int)req.getParameter((Parameter)StandardParameters.discussionsize, 100L);
        String comments = req.getParameter((Parameter)StandardParameters.comments, "all");
        boolean archived = req.getParameter((Parameter)StandardParameters.archived, false);
        Database db = req.getDatabase();
        Collection discussions = DatabaseQuery.getDiscussionsByGroups((Database)db, null, (Group)req.getGroup(), (int)page, (int)pagesize, null, (archived || "archive".equals(comments) ? 1 : 0) != 0);
        for (Discussion disc : discussions) {
            if ("all".equals(comments)) {
                disc.loadAllComments(db, discussionSize);
            } else if ("first".equals(comments)) {
                disc.loadFirstComment(db);
            } else if ("last".equals(comments)) {
                disc.loadLastComment(db, true);
            } else if ("archive".equals(comments)) {
                disc.loadArchiveComments(db, discussionSize);
            }
            disc.loadUri(db, req.getGroup());
        }
        Collection<Group> groups = Comments.getReturnGroups(req);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("discussions");
        out.startCollection("discussions", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Discussion discussion : discussions) {
            out.writeDiscussion(discussion, null, groups);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

