/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Member;
import com.pageseeder.member.MemberErrorID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

@Output(types={OutputType.XML, OutputType.JSON})
public final class GetDiscussions
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 10L;
    private static final long DEFAULT_DISCUSSION_SIZE = 100L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 10L);
        int discussionSize = (int)req.getParameter((Parameter)StandardParameters.discussionsize, 100L);
        String comments = req.getParameter((Parameter)StandardParameters.comments, "all");
        String returngroups = req.getParameter((Parameter)StandardParameters.returngroups, "none");
        String project = req.getNonEmptyParameter((Parameter)StandardParameters.project);
        Database db = req.getDatabase();
        Member mem = req.getMember();
        if (mem == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_REQUIRED);
            return;
        }
        UserDetails userdetails = new UserDetailsManager().get(db, mem.getId(), false);
        Collection<Object> grps = new ArrayList(userdetails.flags().keySet());
        if (!"all".equals(returngroups)) {
            grps.remove("admin");
        }
        if (project != null) {
            grps = GroupRule.removeNonProjectGroupNames(grps, (String)project);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        Collection discussions = DatabaseQuery.getDiscussionsByGroups((Database)db, grps, null, (int)page, (int)pagesize, (Date)cal.getTime(), (boolean)false);
        if (discussions.size() < pagesize) {
            discussions = DatabaseQuery.getDiscussionsByGroups((Database)db, grps, null, (int)page, (int)pagesize, null, (boolean)false);
        }
        Collection groups = GroupRule.getGroupsByNames((Database)db, grps);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("discussions");
        out.startCollection("discussions", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Discussion disc : discussions) {
            if ("all".equals(comments)) {
                disc.loadAllComments(db, discussionSize);
            } else if ("first".equals(comments)) {
                disc.loadFirstComment(db);
            } else if ("last".equals(comments)) {
                disc.loadLastComment(db, true);
            } else if ("archive".equals(comments)) {
                disc.loadArchiveComments(db, discussionSize);
            }
            disc.loadUri(db, null);
            out.writeDiscussion(disc, db, groups);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

