/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewXLinkCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.XLink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Requires(group=true, parameters={"id"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetDiscussionForGroup
implements Generator,
MultipleCheck {
    private static final long DEFAULT_DISCUSSION_SIZE = 1000L;

    public List<PermissionCheck> getPermissionChecks(GeneratorRequest req) throws DatabaseException {
        ArrayList<PermissionCheck> checks = new ArrayList<PermissionCheck>();
        checks.add((PermissionCheck)new ViewGroupCheck(req.getGroup()));
        XLink xl = DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)req.getParameter((Parameter)StandardParameters.id, -1L));
        if (xl == null) {
            checks.add((PermissionCheck)new NoCheck());
        } else {
            checks.add((PermissionCheck)new ViewXLinkCheck(xl));
        }
        return checks;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Discussion disc = DatabaseQuery.getDiscussionByGroups((Database)req.getDatabase(), (Long)req.getParameter((Parameter)StandardParameters.id, -1L), Collections.singleton(req.getGroup()));
        if (disc == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)CommentErrorID.DISCUSSION_NOT_FOUND, "No discussion found with ID " + req.getParameter((Parameter)StandardParameters.id, -1L));
            return;
        }
        String comments = req.getParameter((Parameter)StandardParameters.comments, "all");
        int discussionSize = (int)req.getParameter((Parameter)StandardParameters.discussionsize, 1000L);
        if ("all".equals(comments)) {
            disc.loadAllComments(req.getDatabase(), discussionSize);
        } else if ("first".equals(comments)) {
            disc.loadFirstComment(req.getDatabase());
        } else if ("last".equals(comments)) {
            disc.loadLastComment(req.getDatabase(), true);
        } else if ("archive".equals(comments)) {
            disc.loadArchiveComments(req.getDatabase(), discussionSize);
        }
        disc.loadUri(req.getDatabase(), req.getGroup());
        UniversalPrinter out = res.getUniversalWriter();
        out.writeDiscussion(disc, null, null);
        out.flush();
    }
}

