/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditXLinkCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewXLinkCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Groups;
import com.pageseeder.db.util.XLinks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

@Requires(parameters={"id"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetDiscussion
implements Generator,
SingleCheck {
    private static final long DEFAULT_DISCUSSION_SIZE = 1000L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        boolean moderation = "true".equals(req.getParameter((Parameter)StandardParameters.moderation, "false"));
        NoCheck check = new NoCheck();
        XLink xl = DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)req.getParameter((Parameter)StandardParameters.id, -1L));
        if (xl != null) {
            xl = XLinks.getThreadRoot((XLink)xl);
            check = new ViewXLinkCheck(xl);
            if (moderation) {
                EditXLinkCheck edit = new EditXLinkCheck(URIRule.getURIByXLink((XLink)xl), xl);
                edit.setChangeCreated(true);
                check = edit;
            }
        }
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
        }
        return check;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String returnGroups = req.getParameter((Parameter)StandardParameters.returngroups, "none");
        int discussionSize = (int)req.getParameter((Parameter)StandardParameters.discussionsize, 1000L);
        boolean moderation = "true".equals(req.getParameter((Parameter)StandardParameters.moderation, "false"));
        Database db = req.getDatabase();
        UserDetails userdetails = req.getMember() != null ? new UserDetailsManager().get(db, req.getMember().getId(), false) : SecurityUtils.getDefaultUserDetails();
        ArrayList grps = new ArrayList(userdetails.flags().keySet());
        Group currentGroup = req.getGroup();
        if (currentGroup != null && !grps.contains(currentGroup.getName()) && MemberRule.isAdministrator((Map)userdetails.flags())) {
            grps.add(currentGroup.getName());
        }
        if (!"all".equals(returnGroups)) {
            grps.remove("admin");
        }
        Collection grpc = GroupRule.getGroupsByNames((Database)db, grps);
        XLink xl = DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)req.getParameter((Parameter)StandardParameters.id, -1L));
        if (xl == null || !XLinks.isComment((XLink)xl)) {
            if (req.getParameter((Parameter)StandardParameters.task, false)) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)CommentErrorID.TASK_NOT_FOUND, "No task or reply found with ID " + req.getParameter((Parameter)StandardParameters.id, -1L));
            } else {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)CommentErrorID.DISCUSSION_NOT_FOUND, "No discussion or reply found with ID " + req.getParameter((Parameter)StandardParameters.id, -1L));
            }
            return;
        }
        Discussion disc = new Discussion(XLinks.getThreadRoot((XLink)xl), Groups.getGroupNames((Collection)grpc));
        disc.setForModeration(moderation);
        String comments = req.getParameter((Parameter)StandardParameters.comments, "all");
        boolean draft = req.getParameter((Parameter)StandardParameters.draft, false);
        if ("all".equals(comments)) {
            disc.loadAllComments(req.getDatabase(), discussionSize);
        } else if ("first".equals(comments)) {
            disc.loadFirstComment(req.getDatabase());
        } else if ("last".equals(comments)) {
            disc.loadLastComment(req.getDatabase(), true);
        } else if ("archive".equals(comments)) {
            disc.loadArchiveComments(req.getDatabase(), discussionSize);
        }
        disc.loadUri(req.getDatabase(), null);
        if (draft) {
            disc.loadDraftComment(db, req.getMember());
        }
        UniversalPrinter out = res.getUniversalWriter();
        String element = req.getParameter((Parameter)StandardParameters.task, false) ? "task" : "discussion";
        Collection groups = !"none".equals(returnGroups) ? grpc : null;
        out.writeDiscussion(disc, element, db, groups, true, true, moderation, userdetails);
        out.flush();
    }
}

