/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.AddXLinksCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkChanges;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.state.GroupStateManager;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.comment.Comments;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Groups;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.db.util.URIs;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSRequester;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(parameters={"content"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateComment
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateComment.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        String urlParameter;
        NoCheck check = new NoCheck();
        long replyid = req.getParameter((Parameter)StandardParameters.reply, -1L);
        XLink replyto = replyid == -1L ? null : DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)replyid);
        URI uri = this.getURI(req, replyto);
        String groups = req.getParameter((Parameter)StandardParameters.groups);
        if (replyto != null) {
            XLink threadRoot = XLinks.getThreadRoot((XLink)replyto);
            groups = String.join((CharSequence)",", GroupRule.getGroupNames((Collection)GroupRule.removeAdminGroup((Collection)XLinkRule.getGroups((XLink)threadRoot))));
        }
        if ((urlParameter = req.getParameter((Parameter)StandardParameters.url)) != null) {
            try {
                if (!URIRule.isExternal((URL)RuleUtils.urlEncodeNormalize((String)urlParameter), (Database)req.getDatabase())) {
                    check = new AddXLinksCheck(req.getParameter((Parameter)StandardParameters.url), groups);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (uri != null && !URIs.isExternal((URI)uri)) {
            check = new AddXLinksCheck(uri, groups);
        }
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
        }
        return check;
    }

    private URI getURI(GeneratorRequest req, @Nullable XLink replyto) throws DatabaseException {
        if (replyto != null) {
            return URIRule.getURIByXLink((XLink)replyto);
        }
        URI uri = req.getURI();
        if (uri == null && req.getGroup() != null) {
            uri = URIRule.getURIForGeneralDiscussion((Database)req.getDatabase(), null, (Group)req.getGroup());
        }
        return uri;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String[] groupnames;
        ArrayList<Group> grpc;
        UserDetails userdetails;
        Database db = req.getDatabase();
        long replyid = req.getParameter((Parameter)StandardParameters.reply, -1L);
        XLink replyto = replyid == -1L ? null : DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)replyid);
        URI uri = this.getURI(req, replyto);
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        String url = req.getParameter((Parameter)StandardParameters.url);
        if (url != null) {
            if (uri != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTEXT_AMBIGUOUS, "Can not specifiy both uri and url.");
                return;
            }
            try {
                URL urlObject = RuleUtils.urlEncodeNormalize((String)url);
                if (URIRule.isExternal((URL)urlObject, (Database)db)) {
                    uri = URIRule.createURIForURLDocidBehaviorDescUserTitleType((Database)db, (Transaction)req.getTransaction(), (URL)urlObject, null, null, null, null, null);
                } else {
                    uri = URIRule.getURIByURL((Database)db, (URL)urlObject);
                    if (uri == null) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URL_NOT_FOUND, "The URL is internal and not found.");
                        return;
                    }
                }
                fragment = urlObject.getRef();
            }
            catch (MalformedURLException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URL_INVALID);
                return;
            }
        } else if (uri == null) {
            if (req.getGroup() != null) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)CommentErrorID.NO_GENERAL_DISCUSSION);
            } else {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URL_NOT_SPECIFIED);
            }
            return;
        }
        if (fragment == null) {
            fragment = "default";
        } else if (URIRule.isInvalidFragment((URI)uri, (Group)req.getGroup(), (String)fragment, (Database)req.getDatabase())) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_CASE_MISMATCH, "A fragment with this ID already exists with a different case");
            return;
        }
        String title = req.getParameter((Parameter)StandardParameters.title);
        String content = req.getParameter((Parameter)StandardParameters.content);
        String groups = req.getParameter((Parameter)StandardParameters.groups);
        String contenttype = req.getParameter((Parameter)StandardParameters.contenttype, "text/plain").toLowerCase();
        String properties = req.getParameter((Parameter)StandardParameters.properties);
        String type = req.getParameter((Parameter)StandardParameters.type);
        String labels = req.getParameter((Parameter)StandardParameters.labels);
        String urls = req.getParameter((Parameter)StandardParameters.urls);
        String uris = req.getParameter((Parameter)StandardParameters.uris);
        boolean draft = req.getParameter((Parameter)StandardParameters.draft, false);
        String notifyParameter = req.getParameter((Parameter)StandardParameters.notify, "text/plain".equals(contenttype) ? "normal" : "silent");
        String returngroups = req.getParameter((Parameter)StandardParameters.returngroups, "none");
        if (!Comments.checkLabels(res, labels)) {
            return;
        }
        if (!Comments.checkStatus(res, req.getParameter((Parameter)StandardParameters.status))) {
            return;
        }
        if (!Comments.checkPriority(res, req.getParameter((Parameter)StandardParameters.priority))) {
            return;
        }
        Notify notify = Notify.fromString((String)notifyParameter);
        if (notify == Notify.UNKNOWN) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The notify parameter is invalid.");
            return;
        }
        if (replyto != null && (!XLinks.isComment((XLink)replyto) || XLinks.isWorkflow((XLink)replyto))) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.NOT_A_COMMENT, "The reply specified is not a comment.");
            return;
        }
        if (title == null && replyto == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "A title is required.");
            return;
        }
        try {
            content = XLinkRule.validateContent((String)contenttype, (String)content);
        }
        catch (FoundationException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTENT_INVALID, ex.getMessage());
            return;
        }
        XLink xl = XLink.create((Database)db);
        xl.setContentRole(urls == null && uris == null ? "Comment" : "File Attachment");
        xl.setModeratorOnly(Boolean.FALSE);
        xl.setType(type);
        XLink threadLast = this.setTaskDetails(req, res, db, xl, replyto);
        if (threadLast == null) {
            return;
        }
        if (title == null && replyto != null) {
            title = threadLast.getContentTitle();
        }
        xl.setContentTitle(title);
        Long memberid = null;
        if (req.getMember() != null) {
            UserDetailsManager userManager = new UserDetailsManager();
            userdetails = userManager.get(db, req.getMember().getId());
            memberid = req.getMember().getId();
        } else {
            userdetails = SecurityUtils.getDefaultUserDetails();
        }
        Member moderator = null;
        boolean contributor = false;
        boolean manager = false;
        boolean external = URIs.isExternal((URI)uri);
        Collection uriGroups = null;
        if (!external) {
            uriGroups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
            contributor = MemberRule.isContributorForGroups((UserDetails)userdetails, (Collection)uriGroups);
            manager = MemberRule.isManagerForGroups((UserDetails)userdetails, (Collection)uriGroups);
        }
        Permissions perm = new Permissions();
        XLink threadRoot = null;
        if (replyto != null) {
            threadRoot = XLinks.getThreadRoot((XLink)replyto);
            grpc = XLinkRule.getGroups((XLink)threadRoot);
            if ((grpc = GroupRule.removeAdminGroup((Collection)grpc)).isEmpty()) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Not allowed to add comments to reply groups.");
                return;
            }
            groupnames = Groups.getGroupNames(grpc).toArray(new String[grpc.size()]);
        } else if (groups != null) {
            groupnames = groups.split(",");
        } else if (req.getGroup() != null) {
            groupnames = new String[]{req.getGroup().getName()};
        } else {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Group not specified.");
            return;
        }
        grpc = new ArrayList<Group>();
        for (String groupname : groupnames) {
            MemberForGroup mod;
            Group grp = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
            if (grp == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Invalid group name: " + groupname);
                return;
            }
            if (!PermissionManager.check((Long)memberid, (UserDetails)userdetails, (Database)db, (Permissions)perm, (PermissionCheck)new AddXLinksCheck(grp))) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Not allowed to add comments to group: " + groupname);
                return;
            }
            if (!(replyto != null || external || uriGroups.contains(grp) || GroupRule.isSubGroup((Collection)uriGroups, (Group)grp) || memberid != null && groupnames.length == 1 && groupname.trim().equalsIgnoreCase(GroupRule.getMemberPersonalGroupName((Long)memberid)))) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Internal URI " + uri.getId() + " is not accessible to group: " + groupname);
                return;
            }
            if (!(perm.getSetGroups() && !GroupRule.moderationRequired((Group)grp) || (mod = DatabaseQuery.getModeratorByGroupId((Database)db, (Long)grp.getId())) == null || mod.getMember().equals((Object)req.getMember()))) {
                moderator = mod.getMember();
            }
            if (perm.getSetGroups()) {
                contributor = true;
            }
            if (perm.getEditAllXLinks()) {
                manager = true;
            }
            grpc.add(grp);
        }
        String created = req.getParameter((Parameter)StandardParameters.created);
        if (manager && created != null) {
            try {
                xl.setDate(ISO8601.DATETIME.parse(created));
            }
            catch (ParseException e) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DATE_INVALID, "The created date is invalid.");
                return;
            }
            xl.setModifiedDate(new Date());
            xl.setModifiedBy(req.getMember());
        } else {
            xl.setDate(new Date());
        }
        if (!this.setAuthor(req, res, xl, manager)) {
            return;
        }
        if (draft) {
            List drafts;
            if (replyid != -1L && req.getMember() != null && !(drafts = DatabaseQuery.getCommentDraftsByMemberReplyTo((Database)db, (Long)req.getMember().getId(), (Long)replyid)).isEmpty()) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DRAFT_ALREADY_EXISTS);
                return;
            }
            xl.setAccepted(Boolean.valueOf(false));
            xl.setAuthorOnly(Boolean.valueOf(true));
        } else if (moderator != null) {
            xl.setAccepted(Boolean.valueOf(false));
            xl.setModifiedBy(moderator);
        } else {
            xl.setAccepted(Boolean.valueOf(true));
            if (replyto != null) {
                threadRoot.setThreadEnd(xl);
            } else {
                xl.setThreadEnd(xl);
            }
        }
        Map props = ObjectProperties.toMap((String)properties);
        if (labels != null && !labels.isEmpty()) {
            props.put("label", Arrays.asList(labels.split(",")));
        }
        xl.setProperties(ObjectProperties.toString((Map)props));
        boolean isPublic = XLinkRule.addGroups((Database)db, (XLink)xl, (String[])groupnames);
        Content cont = Content.create((Database)db);
        cont.setType(contenttype);
        cont.setData(content);
        xl.addContents(cont);
        Collection<URI> attachUrls = Comments.attachURLs(db, xl, urls, res);
        if (attachUrls == null) {
            return;
        }
        Collection<URI> attachUris = Comments.attachURIs(db, xl, uris, res);
        if (attachUris == null) {
            return;
        }
        attachUris.addAll(attachUrls);
        xl = xl.insert(db);
        XLinkRule.addXLink((Database)db, (XLink)xl, (URI)uri, (String)fragment, (Long)(replyid == -1L ? null : Long.valueOf(replyid)));
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("comment-creation");
        if (!draft) {
            for (Group grp : grpc) {
                Date modified = new Date();
                GroupStateManager.singleton().setCommentsModified(grp, modified);
            }
            req.getTransaction().commitAndStart();
            if (!this.sendNotification(req, res, db, (OutputPrinter)out, xl, uri, contributor, replyid == -1L ? null : threadLast, notify)) {
                return;
            }
            if (xl.getAccepted().booleanValue()) {
                ChangesManager.getInstance().createComment(db, xl, grpc);
            }
            if (URIs.canBeIndexedAsURL((URI)uri)) {
                IndexMaster.getInstance().indexURL(uri.getId(), false, null, new PSRequester("Creating comment " + xl.getId()));
            }
        }
        if (isPublic) {
            out.field("public", true);
        }
        out.writeComment(xl, db, null, "none".equals(returngroups) ? null : grpc, true, true, true, false);
        out.endObject();
        out.flush();
    }

    private @Nullable XLink setTaskDetails(GeneratorRequest req, GeneratorResponse res, Database db, XLink xl, XLink replyTo) throws QueryFailedException {
        String status;
        XLink threadRoot;
        XLink end;
        String lastStatus = null;
        Member lastAssignedto = null;
        Date lastAssignedtoDate = null;
        String lastPriority = null;
        Date lastDuedate = null;
        XLink lastone = xl;
        if (replyTo != null && (end = (threadRoot = XLinks.getThreadRoot((XLink)replyTo)).getThreadEnd()) != null) {
            lastone = end;
            lastStatus = lastone.getStatus();
            lastAssignedto = lastone.getAssignedTo();
            lastAssignedtoDate = lastone.getAssignedDate();
            lastPriority = lastone.getPriority();
            lastDuedate = lastone.getDueDate();
        }
        if ((status = this.getStatus(req, lastStatus)) == null) {
            return lastone;
        }
        xl.setStatus(status);
        String priority = this.getPriority(req, lastPriority);
        xl.setPriority(priority);
        try {
            Date duedate = this.getDueDate(req, lastDuedate);
            xl.setDueDate(duedate);
        }
        catch (ParseException e) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DUEDATE_INVALID);
            return null;
        }
        try {
            Member assignedtoMember = this.getAssignedtoMember(req, lastAssignedto, db);
            xl.setAssignedTo(assignedtoMember);
            if (assignedtoMember != null) {
                if (!assignedtoMember.equals((Object)lastAssignedto)) {
                    xl.setAssignedDate(new Date());
                } else if (lastAssignedtoDate != null) {
                    xl.setAssignedDate(new Date(lastAssignedtoDate.getTime()));
                }
            }
        }
        catch (IllegalArgumentException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.ASSIGNEDTO_INVALID);
            return null;
        }
        return lastone;
    }

    private boolean setAuthor(GeneratorRequest req, GeneratorResponse res, XLink xl, boolean manager) throws QueryFailedException {
        Member author = req.getMember();
        String authorname = req.getParameter((Parameter)StandardParameters.authorname);
        String authoremail = req.getParameter((Parameter)StandardParameters.authoremail);
        if (author != null) {
            if (manager && (authorname != null && !authorname.isEmpty() || authoremail != null && !authoremail.isEmpty())) {
                if (authoremail != null && !authoremail.isEmpty() && !"No Email".equals(authoremail)) {
                    if (!Emails.isAddress((String)authoremail)) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_EMAIL);
                        return false;
                    }
                    author = DatabaseQuery.getMemberByEmail((Database)req.getDatabase(), (String)authoremail);
                } else {
                    author = null;
                    authoremail = "No Email";
                }
                if (author != null) {
                    xl.setMember(author);
                } else {
                    if (authorname == null || authorname.isEmpty()) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.AUTHOR_MISSING);
                        return false;
                    }
                    xl.setAuthorName(authorname);
                    xl.setAuthorEmail(authoremail);
                }
                xl.setModifiedDate(new Date());
                xl.setModifiedBy(req.getMember());
            } else {
                xl.setMember(author);
            }
        } else {
            if (authorname == null || authorname.isEmpty()) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.AUTHOR_MISSING);
                return false;
            }
            if (authoremail != null && !authoremail.isEmpty() && !"No Email".equals(authoremail)) {
                if (!Emails.isAddress((String)authoremail)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_EMAIL);
                    return false;
                }
                author = DatabaseQuery.getMemberByEmail((Database)req.getDatabase(), (String)authoremail);
            } else {
                authoremail = "No Email";
            }
            if (author != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.AUTHOR_EXISTING, "Please login to use an existing email");
                return false;
            }
            xl.setAuthorName(authorname);
            xl.setAuthorEmail(authoremail);
        }
        return true;
    }

    private boolean sendNotification(GeneratorRequest req, GeneratorResponse res, Database db, OutputPrinter out, XLink xl, URI uri, boolean contributor, XLink threadLast, Notify notify) {
        if (!contributor && req.getAuthenticatedMember() != null) {
            UserDetails userdetails = new UserDetailsManager().get(db, req.getAuthenticatedMember().getId());
            contributor = MemberRule.isAdministrator((Map)userdetails.flags());
        }
        XLinkChanges changes = new XLinkChanges(uri, Boolean.valueOf(Emails.getNotifyAsyncParameter((GeneratorRequest)req)));
        boolean hasTaskChanged = threadLast != null && (!this.compare(threadLast.getStatus(), xl.getStatus()) || !this.compare(threadLast.getPriority(), xl.getPriority()) || !this.compare(threadLast.getAssignedTo(), xl.getAssignedTo()) || !this.compare(threadLast.getDueDate(), xl.getDueDate()));
        String changeType = threadLast == null && xl.getStatus() != null || hasTaskChanged ? "status-added" : "added";
        boolean accepted = xl.getAccepted();
        if (!accepted) {
            changeType = "moderated";
        }
        if (!contributor && notify != Notify.NORMAL) {
            notify = Notify.NORMAL;
            out.field("notify-param-ignored", true);
        }
        changes.addXLinkChange(xl, changeType, notify);
        try {
            changes.process(req.getDatabase());
            if (changes.getStatus() != XLinkChanges.ChangeStatus.SUCCESS) {
                changes.rollback(req.getDatabase());
                LOGGER.warn("Comment could not be submitted! XLinkChanges Status: {} Message: {}", (Object)changes.getStatus(), (Object)changes.getStatusMessage());
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)CommentErrorID.CREATE_FAILED, "Failed to create new comment: " + changes.getStatusMessage());
                return false;
            }
            if (changes.getStatusMessage() != null && accepted) {
                out.field("notification-email-delayed", true);
            }
        }
        catch (EmailException ex) {
            if (!accepted) {
                out.field("moderator-email-failed", true);
            } else {
                out.field("notification-email-failed", true);
            }
        }
        catch (DatabaseException ex) {
            changes.rollback(req.getDatabase());
            LOGGER.error("Database error when submitting a new comment", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)CommentErrorID.CREATE_FAILED, "Failed to create new comment: " + ex.getMessage());
            return false;
        }
        return true;
    }

    private boolean compare(Object value1, Object value2) {
        return value1 != null && value1.equals(value2) || value1 == null && value2 == null;
    }

    private @Nullable String getStatus(GeneratorRequest req, @Nullable String lastStatus) {
        String status = req.getParameter((Parameter)StandardParameters.status);
        if (Strings.isEmpty((String)status)) {
            return lastStatus;
        }
        return status;
    }

    private @Nullable String getPriority(GeneratorRequest req, @Nullable String lastPriority) {
        String priority = req.getParameter((Parameter)StandardParameters.priority);
        return priority == null ? lastPriority : priority;
    }

    private @Nullable Date getDueDate(GeneratorRequest req, @Nullable Date lastDueDate) throws ParseException {
        String duedate = req.getParameter((Parameter)StandardParameters.due);
        if (duedate == null) {
            return lastDueDate;
        }
        if (duedate.isEmpty()) {
            return null;
        }
        return XLinkRule.parseDueDate((String)duedate);
    }

    private @Nullable Member getAssignedtoMember(GeneratorRequest req, @Nullable Member lastAssignedtoMember, Database db) throws IllegalArgumentException, QueryFailedException {
        String assignedto = req.getParameter((Parameter)StandardParameters.assignedto);
        if (assignedto == null) {
            return lastAssignedtoMember;
        }
        if (assignedto.isEmpty()) {
            return null;
        }
        long memberId = Long.parseLong(assignedto);
        Member assignedtoMember = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
        if (assignedtoMember == null) {
            throw new IllegalArgumentException();
        }
        return assignedtoMember;
    }
}

