/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class Comments {
    private static final String VALID_LABELS = "[a-zA-Z0-9_\\-,]*";
    private static final String VALID_PRIORITY = "[a-zA-Z0-9, _-]+";
    private static final String VALID_STATUS = "[a-zA-Z0-9, _-]+";

    private Comments() {
    }

    static @Nullable Collection<URI> attachURLs(Database db, XLink xl, String urls, GeneratorResponse res) throws DatabaseException {
        ArrayList<URI> attachUris = new ArrayList<URI>();
        if (urls != null) {
            String[] attachUrls;
            String[] stringArray = attachUrls = urls.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String attachUrl;
                String aurl = attachUrl = stringArray[i];
                while (aurl.endsWith("/")) {
                    aurl = aurl.substring(0, aurl.length() - 1);
                }
                if ("".equals(aurl)) continue;
                try {
                    URI auri;
                    URL urlo = RuleUtils.urlEncodeNormalize((String)aurl);
                    if (URIRule.isExternal((URL)urlo, (Database)db)) {
                        auri = URIRule.createURIForURLDocidBehaviorDescUserTitleType((Database)db, null, (URL)urlo, null, null, null, null, null);
                    } else {
                        auri = URIRule.getURIByURL((Database)db, (URL)urlo);
                        if (auri == null) {
                            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URL_NOT_FOUND, "One of the URLS is internal and not found.");
                            return null;
                        }
                    }
                    String frag = urlo.getRef() != null ? urlo.getRef() : "default";
                    LocatorRule.addXLinkToLocator((Database)db, (XLink)xl, (URI)auri, (String)frag, (String)"page-link", (String)"file-attachment", null);
                    attachUris.add(auri);
                    continue;
                }
                catch (MalformedURLException ex) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URL_INVALID, "Invalid URL: " + aurl);
                    return null;
                }
            }
        }
        return attachUris;
    }

    static @Nullable Collection<URI> attachURIs(Database db, XLink xl, String uris, GeneratorResponse res) throws QueryFailedException, DatabaseException {
        ArrayList<URI> attachUris = new ArrayList<URI>();
        if (uris != null) {
            String[] attachUriFrags;
            for (String uri_frag : attachUriFrags = uris.split(",")) {
                int i = uri_frag.indexOf(33);
                String frag = "default";
                String id = uri_frag;
                if (i != -1) {
                    frag = uri_frag.substring(i + 1);
                    id = uri_frag.substring(0, i);
                }
                if ("".equals(id)) continue;
                try {
                    Long uriid = Long.parseLong(id);
                    URI auri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                    if (auri == null || "".equals(frag)) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URI_NOT_FOUND, "URI Not found: " + uri_frag);
                        return null;
                    }
                    LocatorRule.addXLinkToLocator((Database)db, (XLink)xl, (URI)auri, (String)frag, (String)"page-link", (String)"file-attachment", null);
                    attachUris.add(auri);
                }
                catch (NumberFormatException ex) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URI_NOT_FOUND, "URI Not found: " + uri_frag);
                    return null;
                }
            }
        }
        return attachUris;
    }

    public static boolean checkLabels(@Nullable GeneratorResponse res, @Nullable String labels) {
        if (Strings.isEmpty((String)labels) || labels.matches(VALID_LABELS)) {
            return true;
        }
        if (res != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.LABELS_INVALID);
        }
        return false;
    }

    public static boolean checkPriority(GeneratorResponse res, @Nullable String priority) {
        if (Strings.isEmpty((String)priority) || priority.matches("[a-zA-Z0-9, _-]+")) {
            return true;
        }
        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.PRIORITY_INVALID);
        return false;
    }

    public static boolean checkStatus(GeneratorResponse res, @Nullable String status) {
        if (Strings.isEmpty((String)status) || status.matches("[a-zA-Z0-9, _-]+")) {
            return true;
        }
        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.STATUS_INVALID);
        return false;
    }

    public static @Nullable Collection<Group> getReturnGroups(GeneratorRequest req) throws DatabaseException {
        String returngroups = req.getParameter((Parameter)StandardParameters.returngroups, "none");
        if ("none".equals(returngroups)) {
            return null;
        }
        UserDetails userdetails = req.getMember() != null ? new UserDetailsManager().get(req.getDatabase(), req.getMember().getId(), false) : SecurityUtils.getDefaultUserDetails();
        return Comments.getReturnGroups(returngroups, req.getGroup(), userdetails, req.getDatabase());
    }

    public static Collection<Group> getReturnGroups(String returngroups, @Nullable Group currentGroup, @Nullable UserDetails userdetails, Database db) throws DatabaseException {
        ArrayList grps = new ArrayList(userdetails.flags().keySet());
        if (!"all".equals(returngroups)) {
            grps.remove("admin");
        }
        if (currentGroup != null && !grps.contains(currentGroup.getName()) && MemberRule.isAdministrator((Map)userdetails.flags())) {
            grps.add(currentGroup.getName());
        }
        return GroupRule.getGroupsByNames((Database)db, grps);
    }

    public static void indexCommentsTasksWorkflows(Database db, URI uri, ChangesManager manager, ChangesBatch batch) throws QueryFailedException {
        List xlinks = DatabaseQuery.getCommentsByURIGroups((Database)db, (int)1, (int)-1, Collections.singleton("admin"), (Long)uri.getId());
        List workflows = DatabaseQuery.getXLinksByURIRootWorkflowAllGroups((Database)db, (URI)uri);
        xlinks.addAll(workflows);
        for (XLink xlink : xlinks) {
            Collection cgroups = XLinkRule.getGroups((XLink)xlink);
            manager.modifyComment(db, batch, xlink, cgroups);
        }
    }
}

