/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.cache;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import java.io.Serializable;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;

@Requires(parameters={"name", "key"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class RemoveCacheElement
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String name = req.getParameter((Parameter)StandardParameters.name);
        String key = req.getParameter((Parameter)StandardParameters.key);
        assert (name != null && key != null);
        CacheManager manager = CacheManager.getInstance();
        Ehcache cache = manager.getEhcache(name);
        if (cache == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Cache not found with specified 'name'.");
            return;
        }
        boolean removed = cache.remove((Serializable)((Object)key));
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("clear-entry");
        out.startObject("cache");
        out.field("name", cache.getName());
        out.field("guid", cache.getGuid());
        out.endObject();
        out.startObject("element");
        out.field("key", key);
        out.field("removed", Boolean.toString(removed));
        out.endObject();
        out.endObject();
        out.flush();
    }
}

