/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.cache;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.DatabaseQuery;
import java.io.IOException;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.eclipse.jdt.annotation.Nullable;

@Requires(parameters={"name"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetCacheElements
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String name = req.getParameter((Parameter)StandardParameters.name);
        int page = Integer.parseInt(req.getParameter((Parameter)StandardParameters.page, "1"));
        int perpage = Integer.parseInt(req.getParameter((Parameter)StandardParameters.pagesize, "5000"));
        perpage = DatabaseQuery.getMaxPageSize((int)perpage);
        CacheManager manager = CacheManager.getInstance();
        Ehcache cache = manager.getEhcache(name);
        if (cache == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Cache not found with specified 'name'.");
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        GetCacheElements.print(cache, page, perpage, (OutputPrinter)out);
        out.flush();
    }

    private static void print(@Nullable Ehcache cache, int page, int nbPerPage, OutputPrinter out) {
        if (cache == null) {
            return;
        }
        out.startObject("cache");
        out.field("name", cache.getName());
        out.field("guid", cache.getGuid());
        out.field("status", cache.getStatus().toString());
        out.field("disabled", cache.isDisabled());
        List keys = cache.getKeys();
        int start = (page - 1) * nbPerPage;
        int end = Math.min(start + nbPerPage, keys.size());
        out.startObject("keys");
        out.field("page", (long)page);
        out.field("pagesize", (long)nbPerPage);
        out.field("limitreached", end < keys.size());
        out.field("count", (long)keys.size());
        out.startCollection("elements", OutputPrinter.CollectionOption.JSON_ONLY);
        for (int i = start; i < end; ++i) {
            Object key = keys.get(i);
            out.startObject("element");
            out.field("key", key.toString());
            Element element = cache.getQuiet(key);
            if (element != null) {
                out.field("creation-time", ISO8601.DATETIME.format(element.getCreationTime()));
                out.field("expiration-time", ISO8601.DATETIME.format(element.getExpirationTime()));
                out.field("last-access-time", ISO8601.DATETIME.format(element.getLastAccessTime()));
                out.field("last-update-time", ISO8601.DATETIME.format(element.getLastUpdateTime()));
                out.field("hit-count", element.getHitCount());
                out.field("version", element.getVersion());
                out.field("time-to-idle", (long)element.getTimeToIdle());
                out.field("time-to-live", (long)element.getTimeToLive());
                out.field("eternal", element.isEternal());
                out.field("expired", element.isExpired());
            }
            out.endObject();
        }
        out.endCollection();
        out.endObject();
        out.endObject();
    }
}

