/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai.core;

import com.pageseeder.ai.core.AttachmentManager;
import com.pageseeder.ai.core.IntelligenceException;
import com.pageseeder.ai.core.RedactionEngine;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import java.util.Map;
import net.pageseeder.ai.prompt.Attachment;
import net.pageseeder.ai.prompt.ContentSpec;
import net.pageseeder.ai.prompt.PromptTemplate;
import net.pageseeder.ai.prompt.TextTemplate;
import org.eclipse.jdt.annotation.Nullable;

public class TemplateBuilder {
    private final Database db;
    private final Group group;
    private final Member member;
    private final PromptTemplate template;
    private final Map<String, String> parameters;
    private final RedactionEngine redaction;
    private int relatedIndex = 0;
    private @Nullable AttachmentManager attachmentManager;

    public TemplateBuilder(Database db, Group group, Member member, PromptTemplate template, Map<String, String> parameters, RedactionEngine redaction) {
        this.db = db;
        this.group = group;
        this.member = member;
        this.template = template;
        this.parameters = parameters;
        this.redaction = redaction;
    }

    public void addDocument(URI uri) throws IntelligenceException {
        this.addDocument(uri, null, null);
    }

    public void addDocument(URI uri, @Nullable Publication publication, @Nullable Map<String, String> metadata) throws IntelligenceException {
        AttachmentManager manager = this.ensureManager(this.db, this.group, this.member);
        try {
            this.parameters.put("document", manager.asDataURI(uri, publication, metadata));
        }
        catch (Exception ex) {
            throw new IntelligenceException("Unable to attach document to prompt", ex);
        }
        boolean hasDocumentAttachment = this.template.listAttachmentRefs().contains("document");
        if (!hasDocumentAttachment) {
            String filename = URIRule.getFilename((URI)uri)[0];
            if (uri.getType().startsWith("image")) {
                this.template.addUser((ContentSpec)new TextTemplate("\n=== BEGIN IMAGE: " + filename + " ===\n"));
            } else {
                this.template.addUser((ContentSpec)new TextTemplate("\n=== BEGIN DOCUMENT: " + filename + " ===\n"));
            }
            this.template.addUser((ContentSpec)new Attachment("document"));
            if (uri.getType().startsWith("image")) {
                this.template.addUser((ContentSpec)new TextTemplate("\n=== END IMAGE ===\n"));
            } else {
                this.template.addUser((ContentSpec)new TextTemplate("\n=== END DOCUMENT ===\n"));
            }
        }
    }

    public void addRelated(URI uri) throws IntelligenceException {
        this.addRelated(uri, null, null);
    }

    public void addRelated(URI uri, @Nullable Publication publication, @Nullable Map<String, String> metadata) throws IntelligenceException {
        String parameterName = "related_document_" + this.relatedIndex;
        AttachmentManager manager = this.ensureManager(this.db, this.group, this.member);
        try {
            this.parameters.put(parameterName, manager.asDataURI(uri, publication, metadata));
        }
        catch (Exception ex) {
            throw new IntelligenceException("Unable to attach related document to prompt", ex);
        }
        String filename = URIRule.getFilenameAsString((String)uri.getDecodedPath());
        if (uri.getType().startsWith("image")) {
            this.template.addUser((ContentSpec)new TextTemplate("\n=== BEGIN ATTACHED IMAGE " + ++this.relatedIndex + ": " + filename + " ===\n"));
        } else {
            this.template.addUser((ContentSpec)new TextTemplate("\n=== BEGIN ATTACHED DOCUMENT " + ++this.relatedIndex + ": " + filename + " ===\n"));
        }
        this.template.addUser((ContentSpec)new Attachment(parameterName));
        if (uri.getType().startsWith("image")) {
            this.template.addUser((ContentSpec)new TextTemplate("\n=== END ATTACHED IMAGE " + this.relatedIndex + " ===\n"));
        } else {
            this.template.addUser((ContentSpec)new TextTemplate("\n=== END ATTACHED DOCUMENT " + this.relatedIndex + " ===\n"));
        }
    }

    private AttachmentManager ensureManager(Database db, Group group, Member member) {
        if (this.attachmentManager == null) {
            this.attachmentManager = new AttachmentManager(db, group, member);
            this.attachmentManager.setRedactionEngine(this.redaction);
        }
        return this.attachmentManager;
    }
}

