/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai.core;

import com.pageseeder.common.properties.GlobalSettings;
import org.slf4j.LoggerFactory;

public enum IntelligenceProvider {
    NONE,
    BEDROCK,
    ANTHROPIC;


    public static IntelligenceProvider fromProperty(String provider) {
        if (provider.isEmpty()) {
            return NONE;
        }
        try {
            return IntelligenceProvider.valueOf(provider.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            LoggerFactory.getLogger(IntelligenceProvider.class).error("Invalid AI provider: {}", (Object)provider);
            return NONE;
        }
    }

    public static IntelligenceProvider getGlobal() {
        return IntelligenceProvider.fromProperty(GlobalSettings.getString((String)"aiProvider", (String)""));
    }
}

