/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai;

import com.pageseeder.ai.anthropic.AnthropicApiClient;
import com.pageseeder.ai.anthropic.BedrockApiClient;
import com.pageseeder.ai.core.AIRequest;
import com.pageseeder.ai.core.IntelligenceConfigException;
import com.pageseeder.ai.core.IntelligenceException;
import com.pageseeder.ai.core.IntelligenceProvider;
import com.pageseeder.ai.core.IntelligenceProviderClient;
import com.pageseeder.ai.core.RedactionEngine;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.pageseeder.ai.anthropic.model.ErrorResponse;
import net.pageseeder.ai.anthropic.model.MessageContent;
import net.pageseeder.ai.anthropic.model.MessageResponse;
import net.pageseeder.ai.anthropic.model.MessageUsage;
import net.pageseeder.ai.anthropic.model.Response;
import net.pageseeder.ai.prompt.PromptTemplate;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.html.HTMLElement;
import org.pageseeder.psml.md.MarkdownParser;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.psml.model.PSMLNode;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(uri=true, group=true, member=true, parameters={"prompt"})
public final class GenerateAnswer
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateAnswer.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        URI uri = req.getURI();
        Group group = req.getGroup();
        assert (uri != null && group != null);
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(group, uri));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Response<MessageResponse> response;
        IntelligenceProvider provider = IntelligenceProvider.getGlobal();
        if (provider == IntelligenceProvider.NONE) {
            res.setError(GeneratorStatus.NOT_IMPLEMENTED, "AI not supported");
            return;
        }
        AIRequest ai = new AIRequest(req);
        Member member = req.getMember();
        Group group = req.getGroup();
        URI uri = req.getURI();
        assert (uri != null && member != null && group != null);
        PromptTemplate template = ai.buildTemplate(res);
        if (template == null) {
            return;
        }
        IntelligenceProviderClient client = this.getClient(provider);
        if (client == null) {
            res.setError(GeneratorStatus.UNAVAILABLE, "No AI client available for provider");
            return;
        }
        try {
            response = client.askModel(template, member, ai.getParameters());
        }
        catch (IntelligenceConfigException ex) {
            res.setError(GeneratorStatus.UNAVAILABLE, ex.getMessage());
            return;
        }
        catch (IntelligenceException ex) {
            LOGGER.error("Unable to communicate with AI provider", (Throwable)ex);
            res.setError(GeneratorStatus.BAD_REQUEST, ex.getMessage());
            return;
        }
        ErrorResponse error = response.getError();
        if (error != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, error.error().message());
            return;
        }
        MessageResponse message = (MessageResponse)response.get();
        assert (message != null);
        UniversalPrinter out = res.getUniversalWriter();
        this.print((OutputPrinter)out, message, ai.getPromptId(), ai.getRedaction());
        out.flush();
    }

    private @Nullable IntelligenceProviderClient getClient(IntelligenceProvider provider) {
        if (provider == IntelligenceProvider.ANTHROPIC) {
            return new AnthropicApiClient();
        }
        if (provider == IntelligenceProvider.BEDROCK) {
            return new BedrockApiClient();
        }
        return null;
    }

    private void print(OutputPrinter printer, MessageResponse message, String promptId, RedactionEngine engine) {
        XMLStringWriter xml;
        MarkdownParser parser;
        String answer = ((MessageContent)message.getContent().get(0)).getText();
        answer = engine.unRedact(answer);
        printer.startObject("ai");
        printer.field("prompt", promptId);
        printer.field("id", message.getId());
        printer.field("type", message.getType());
        printer.field("model", message.getModel());
        MessageUsage usage = message.getUsage();
        if (usage != null) {
            printer.startObject("usage");
            printer.field("input-tokens", (long)usage.getInputTokens());
            printer.field("output-tokens", (long)usage.getOutputTokens());
            printer.endObject();
        }
        printer.field("response", answer, OutputPrinter.FieldOption.XML_ELEMENT);
        try {
            parser = new MarkdownParser();
            PSMLElement psml = parser.parse((Reader)new StringReader(answer));
            xml = new XMLStringWriter(XML.NamespaceAware.No);
            for (PSMLNode node : psml.getNodes()) {
                node.toXML((XMLWriter)xml);
            }
            printer.field("psml", xml.toString(), OutputPrinter.FieldOption.XML_ELEMENT);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to parse markdown as PSML from answer", (Throwable)ex);
        }
        try {
            parser = new MarkdownParser();
            HTMLElement html = parser.parseToHTML((Reader)new StringReader(answer));
            xml = new XMLStringWriter(XML.NamespaceAware.No);
            for (PSMLNode node : html.getNodes()) {
                node.toXML((XMLWriter)xml);
            }
            printer.field("html", xml.toString(), OutputPrinter.FieldOption.XML_ELEMENT);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to parse markdown as HTML from answer", (Throwable)ex);
        }
        if (answer.startsWith("<") && answer.endsWith(">") && XMLHelpers.isWellFormed((String)("<wrapper>" + answer + "</wrapper>"))) {
            printer.field("xml", answer, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        printer.endObject();
        printer.flush();
    }
}

