/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.permission.EditXLinkCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.state.GroupStateManager;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.comment.Comments;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.publish.Publisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class XLinkUpdateLabel
implements Action<XLink> {
    private @Nullable Group group = null;
    private @Nullable LabelUpdater updater = null;
    private final boolean addLabels;

    XLinkUpdateLabel(boolean add) {
        this.addLabels = add;
    }

    @Override
    public PermissionCheck permissionCheck(XLink xl) {
        return new EditXLinkCheck(URIRule.getURIByXLink((XLink)xl), xl);
    }

    @Override
    public ProcessThread initThread(ActionProcessor<XLink> parent, Database db, Transaction tr) throws ActionException {
        String groupNameOrID = parent.getGroupName();
        try {
            this.group = GroupRule.getGroup((Database)db, (String)groupNameOrID);
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load group " + groupNameOrID + ": " + e.getMessage());
        }
        if (this.group == null) {
            throw new ActionException("Invalid group " + groupNameOrID);
        }
        String labelsList = parent.getParameter("labels");
        if (labelsList == null) {
            throw new ActionException("labels parameter missing", true);
        }
        if (!Comments.checkLabels(null, labelsList)) {
            throw new ActionException("labels parameter invalid", true);
        }
        String[] labels = Strings.split((String)labelsList, (char)',');
        this.updater = new LabelUpdater(parent.getMemberUsername(), this.group, labels, this.addLabels);
        ChangesManager.getInstance().startBatch(db, this.updater.batch);
        return this.updater;
    }

    @Override
    public void addObject(XLink xlink, Database db) {
        this.updater.addXLink(xlink);
    }

    @Override
    public @Nullable Publisher initPublisher(ActionProcessor<XLink> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    static class LabelUpdater
    extends ProcessThread {
        private final boolean add;
        private final String[] labels;
        private final ChangesBatch batch;
        private final String username;
        private final List<Long> xlinkids = new ArrayList<Long>();
        private int currentProgress = 0;

        LabelUpdater(String username, Group group, String[] labels, boolean add) {
            super(username, add ? "Adding labels to comments/tasks" : "Removing labels from comments/tasks", group);
            this.add = add;
            this.labels = labels;
            this.username = username;
            this.batch = new ChangesBatch(this.getName());
        }

        private void addXLink(XLink xl) {
            this.xlinkids.add(xl.getId());
        }

        public void process() {
            Member author;
            Transaction tr;
            Database db;
            String labelsString = this.labels.length == 1 ? "1 label" : this.labels.length + " labels";
            try {
                db = Database.open();
                tr = new Transaction(db);
            }
            catch (OpenDatabaseException ex) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to open database");
                return;
            }
            try {
                author = DatabaseQuery.getMemberByUsername((Database)db, (String)this.username);
            }
            catch (QueryFailedException ex) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to load author");
                return;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, (this.add ? "Adding " + labelsString + " to " : "Removing " + labelsString + " from ") + this.xlinkids.size() + " comments/tasks");
            for (Long xlid : this.xlinkids) {
                try {
                    XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)xlid);
                    ++this.currentProgress;
                    if (this.add) {
                        Labels.addLabels((XLink)xl, (String[])this.labels);
                    } else {
                        Labels.removeLabels((XLink)xl, (String[])this.labels);
                    }
                    Date modified = new Date();
                    xl.setModifiedDate(modified);
                    xl.setModifiedBy(author);
                    Collection groups = XLinkRule.getGroups((XLink)xl);
                    for (Group grp : groups) {
                        GroupStateManager.singleton().setCommentsModified(grp, modified);
                    }
                    this.updateStatus(ProcessStage.Status.INPROGRESS, (this.add ? "Added " + labelsString + " to " : "Removed " + labelsString + " from ") + " comment/task " + xlid);
                    if (this.wasCancelled()) {
                        ChangesManager.getInstance().completeBatch(db, this.batch);
                        tr.abort();
                        return;
                    }
                    tr.commitAndStart();
                    ChangesManager.getInstance().modifyComment(db, this.batch, xl, groups);
                }
                catch (DatabaseException ex) {
                    this.updateStatus(ProcessStage.Status.ERROR, "Failed to update XLink " + xlid + ": " + ex.getMessage());
                }
            }
            this.currentProgress = this.xlinkids.size();
            ChangesManager.getInstance().completeBatch(db, this.batch);
            this.complete("Successfully " + (this.add ? "added " + labelsString + " to " : "removed " + labelsString + " from ") + this.xlinkids.size() + " comments/tasks");
        }

        public void writeThreadElements(OutputPrinter out) {
            out.startObject("progress");
            out.field("total", (long)this.xlinkids.size());
            out.field("current", (long)this.currentProgress);
            out.endObject();
        }
    }
}

