/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.action.XLinkUpdateLabel;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XLinkActionProcessor
extends ActionProcessor<XLink> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XLinkActionProcessor.class);
    private static final Collection<String> ALLOWED_CONTENT_ROLES = Arrays.asList("Comment", "File Attachment", "Workflow");

    public XLinkActionProcessor(String name, Map<String, String> params, Member member, String gname, UserDetails details, String token, Database db, Transaction tr) {
        super(name, params, member, gname, details, token, db, tr);
    }

    @Override
    public Action<XLink> createAction(String name) {
        switch (XLinkActionName.valueOf(name)) {
            case addlabel: {
                return new XLinkUpdateLabel(true);
            }
            case removelabel: {
                return new XLinkUpdateLabel(false);
            }
        }
        throw new IllegalArgumentException("'" + name + "' is not a valid batch action for a URI.");
    }

    @Override
    public @Nullable XLink loadObject(Database database, Long id) throws ActionException {
        try {
            XLink xl = DatabaseQuery.getXLinkById((Database)database, (Long)id);
            if (xl != null && !ALLOWED_CONTENT_ROLES.contains(xl.getContentRole())) {
                LOGGER.warn("Batch action ignoring invalid XLink {} with  content role {}", (Object)xl.getId(), (Object)xl.getContentRole());
                return null;
            }
            return xl;
        }
        catch (QueryFailedException ex) {
            throw new ActionException("Failed to load XLink with ID " + id, ex);
        }
    }

    private static enum XLinkActionName {
        addlabel,
        removelabel;

    }
}

