/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.publish.Publisher;
import com.pageseeder.uri.ValidateThread;
import org.eclipse.jdt.annotation.Nullable;

public final class URIValidate
implements Action<URI> {
    private @Nullable ValidateThread thread = null;

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        return new ViewURICheck(uri);
    }

    @Override
    public @Nullable Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        Group group;
        String schematron = parent.getParameter("schema");
        if (schematron == null) {
            throw new ActionException("schema parameter missing", true);
        }
        try {
            group = GroupRule.getGroup((Database)db, (String)parent.getGroupName());
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load group " + parent.getGroupName() + ": " + e.getMessage());
        }
        if (group == null) {
            throw new ActionException("Invalid group " + parent.getGroupName());
        }
        this.thread = ValidateThread.newInstance(parent.getMemberUsername(), group, schematron);
        this.thread.setFailuresOnly("true".equals(parent.getParameter("failures")));
        return this.thread;
    }

    @Override
    public void addObject(URI uri, Database db) {
        this.thread.addURIToValidate(uri.getId());
    }
}

