/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.publish.Publisher;
import com.pageseeder.utils.MemberTempFiles;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import net.pageseeder.xmltools.usage.UsageReportBuilder;
import org.eclipse.jdt.annotation.Nullable;

public final class URIUsageReport
implements Action<URI> {
    private @Nullable String groupname = null;
    private @Nullable ReportBuilder reportBuilder = null;

    @Override
    public @Nullable Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        Group group;
        this.groupname = parent.getGroupName();
        if (this.groupname == null) {
            throw new ActionException("Parameter group is required");
        }
        try {
            group = GroupRule.getGroup((Database)db, (String)this.groupname);
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load group " + this.groupname + ": " + e.getMessage());
        }
        if (group == null) {
            throw new ActionException("Invalid group " + this.groupname);
        }
        File output = null;
        try {
            output = this.initOutputFile(parent.getMemberID());
        }
        catch (IOException e) {
            throw new ActionException(e.getMessage());
        }
        this.reportBuilder = new ReportBuilder(parent.getMemberUsername(), group, output);
        return this.reportBuilder;
    }

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        return new AdminSystemCheck();
    }

    @Override
    public void addObject(URI uri, Database db) throws ActionException {
        try {
            this.reportBuilder.addURI(uri, db);
        }
        catch (URIException e) {
            throw new ActionException("Failed to read URI's content", e);
        }
    }

    private File initOutputFile(Long memberID) throws IOException {
        File tempFolder = MemberTempFiles.getTempFolder(memberID, this.groupname);
        String name = "usage_report";
        return new File(tempFolder, name + ".csv");
    }

    static class ReportBuilder
    extends ProcessThread {
        private final File outputFile;
        private final UsageReportBuilder reporter;
        private final ByteArrayOutputStream log;
        private boolean created = false;

        private ReportBuilder(String username, Group group, File output) {
            super(username, "Generating usage report", group);
            this.outputFile = output;
            this.reporter = new UsageReportBuilder();
            this.log = new ByteArrayOutputStream();
            this.reporter.setLog(new PrintStream(this.log));
        }

        public void addURI(URI uri, Database db) throws URIException {
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), this.getGroup());
            this.reporter.parseStream(resolver.getContent(db));
        }

        public void process() {
            try {
                if (!this.outputFile.exists() && !this.outputFile.createNewFile()) {
                    this.updateStatus(ProcessStage.Status.FAILED, "Failed to create new schema file " + this.outputFile.getName());
                    return;
                }
            }
            catch (IOException ex) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to create new schema file " + this.outputFile.getName() + ": " + ex.getMessage());
                return;
            }
            this.reporter.saveCSVReport(this.outputFile);
            this.created = true;
            this.complete("Usage report was successfully generated");
        }

        public void writeThreadElements(OutputPrinter out) {
            if (!this.created) {
                return;
            }
            out.startObject("usage-report");
            try {
                byte[] errors = this.log.toByteArray();
                if (errors.length > 0) {
                    out.field("status", "error");
                    out.field("errors", new String(errors, StandardCharsets.UTF_8), OutputPrinter.FieldOption.XML_ELEMENT);
                } else {
                    out.field("status", "success");
                    out.field("name", this.outputFile.getName());
                }
            }
            finally {
                out.endObject();
            }
        }
    }
}

